/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.mysql;

import is.codion.common.db.database.AbstractDatabase;
import java.sql.SQLException;
import java.util.Objects;

final class MySQLDatabase
extends AbstractDatabase {
    private static final int REFERENTIAL_CONSTRAINT_ERROR = 1452;
    private static final int UNIQUE_CONSTRAINT_ERROR1 = 1062;
    private static final int UNIQUE_CONSTRAINT_ERROR2 = 1586;
    private static final String JDBC_URL_PREFIX = "jdbc:mysql://";
    static final String AUTO_INCREMENT_QUERY = "SELECT LAST_INSERT_ID() FROM DUAL";

    MySQLDatabase(String url) {
        super(url);
    }

    public String name() {
        String name = MySQLDatabase.removeUrlPrefixOptionsAndParameters((String)this.url(), (String[])new String[]{JDBC_URL_PREFIX});
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        return name;
    }

    public String autoIncrementQuery(String idSource) {
        return AUTO_INCREMENT_QUERY;
    }

    public String selectForUpdateClause() {
        return "FOR UPDATE";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return MySQLDatabase.createLimitOffsetClause((Integer)limit, (Integer)offset);
    }

    public boolean isReferentialIntegrityException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 1452;
    }

    public boolean isUniqueConstraintException(SQLException exception) {
        return Objects.requireNonNull(exception).getErrorCode() == 1062 || exception.getErrorCode() == 1586;
    }
}

