/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.mariadb;

import is.codion.common.db.database.AbstractDatabase;
import java.sql.SQLException;

final class MariaDBDatabase
extends AbstractDatabase {
    private static final int REFERENTIAL_CONSTRAINT_ERROR = 1452;
    private static final int UNIQUE_CONSTRAINT_ERROR1 = 1062;
    private static final int UNIQUE_CONSTRAINT_ERROR2 = 1586;
    private static final int TIMEOUT_ERROR = 1969;
    private static final String JDBC_URL_PREFIX = "jdbc:mariadb://";
    static final String AUTO_INCREMENT_QUERY = "SELECT LAST_INSERT_ID() FROM DUAL";

    MariaDBDatabase(String jdbUrl) {
        super(jdbUrl);
    }

    public String name() {
        String name = MariaDBDatabase.removeUrlPrefixOptionsAndParameters((String)this.url(), (String[])new String[]{JDBC_URL_PREFIX});
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        return name;
    }

    public String autoIncrementQuery(String idSource) {
        return AUTO_INCREMENT_QUERY;
    }

    public String selectForUpdateClause() {
        return "FOR UPDATE";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return MariaDBDatabase.createLimitOffsetClause((Integer)limit, (Integer)offset);
    }

    public boolean isReferentialIntegrityException(SQLException exception) {
        return exception.getErrorCode() == 1452;
    }

    public boolean isUniqueConstraintException(SQLException exception) {
        return exception.getErrorCode() == 1062 || exception.getErrorCode() == 1586;
    }

    public boolean isTimeoutException(SQLException exception) {
        return exception.getErrorCode() == 1969;
    }
}

