/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.h2database;

import is.codion.common.db.database.AbstractDatabase;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

final class H2Database
extends AbstractDatabase {
    private static final int AUTHENTICATION_ERROR = 28000;
    private static final int REFERENTIAL_INTEGRITY_ERROR_CHILD_EXISTS = 23503;
    private static final int REFERENTIAL_INTEGRITY_ERROR_PARENT_MISSING = 23506;
    private static final int UNIQUE_CONSTRAINT_ERROR = 23505;
    private static final int TIMEOUT_ERROR = 57014;
    private static final Set<String> INITIALIZED_DATABASES = new HashSet<String>();
    private static final String JDBC_URL_PREFIX = "jdbc:h2:";
    private static final String JDBC_URL_PREFIX_MEM = "jdbc:h2:mem:";
    private static final String JDBC_URL_PREFIX_FILE = "jdbc:h2:file:";
    private static final String JDBC_URL_PREFIX_TCP = "jdbc:h2:tcp://";
    private static final String JDBC_URL_PREFIX_SSL = "jdbc:h2:ssl:";
    private static final String JDBC_URL_PREFIX_ZIP = "jdbc:h2:zip:";
    private static final String FILE_SUFFIX_PAGESTORE = ".h2.db";
    private static final String FILE_SUFFIX_MVSTORE = ".mv.db";
    static final String AUTO_INCREMENT_QUERY = "CALL IDENTITY()";
    static final String SEQUENCE_VALUE_QUERY = "select next value for ";
    static final String SYSADMIN_USERNAME = "sa";
    private final boolean nowait;

    H2Database(String url) {
        this(url, Collections.emptyList());
    }

    H2Database(String url, List<String> scriptPaths) {
        this(url, scriptPaths, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    H2Database(String url, List<String> scriptPaths, boolean nowait) {
        super(url);
        this.nowait = nowait;
        Set<String> set = INITIALIZED_DATABASES;
        synchronized (set) {
            if (!INITIALIZED_DATABASES.contains(url.toLowerCase())) {
                this.initializeEmbeddedDatabase(scriptPaths);
            }
        }
    }

    public String name() {
        return H2Database.databaseName(this.url());
    }

    public String selectForUpdateClause() {
        if (this.nowait) {
            return "FOR UPDATE NOWAIT";
        }
        return "FOR UPDATE";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return H2Database.createLimitOffsetClause((Integer)limit, (Integer)offset);
    }

    public String autoIncrementQuery(String idSource) {
        return AUTO_INCREMENT_QUERY;
    }

    public String sequenceQuery(String sequenceName) {
        return SEQUENCE_VALUE_QUERY + Objects.requireNonNull(sequenceName, "sequenceName");
    }

    public boolean isAuthenticationException(SQLException exception) {
        return exception.getErrorCode() == 28000;
    }

    public boolean isReferentialIntegrityException(SQLException exception) {
        return exception.getErrorCode() == 23503 || exception.getErrorCode() == 23506;
    }

    public boolean isUniqueConstraintException(SQLException exception) {
        return exception.getErrorCode() == 23505;
    }

    public boolean isTimeoutException(SQLException exception) {
        return exception.getErrorCode() == 57014;
    }

    static String databaseName(String url) {
        String name = H2Database.removeUrlPrefixOptionsAndParameters((String)url, (String[])new String[]{JDBC_URL_PREFIX_TCP, JDBC_URL_PREFIX_FILE, JDBC_URL_PREFIX_MEM, JDBC_URL_PREFIX_SSL, JDBC_URL_PREFIX_ZIP, JDBC_URL_PREFIX});
        return name.isEmpty() ? "private" : name;
    }

    private void initializeEmbeddedDatabase(List<String> scriptPaths) {
        if (this.isEmbeddedInMemory() || !this.databaseFileExists()) {
            Properties properties = new Properties();
            properties.put("user", SYSADMIN_USERNAME);
            if (scriptPaths.isEmpty()) {
                this.initialize(properties, ";DB_CLOSE_DELAY=-1");
            } else {
                for (String scriptPath : scriptPaths) {
                    this.initialize(properties, ";DB_CLOSE_DELAY=-1;INIT=RUNSCRIPT FROM '" + scriptPath.replace("\\", "/") + "'");
                }
            }
        }
        INITIALIZED_DATABASES.add(this.url().toLowerCase());
    }

    private String databasePath() {
        return H2Database.removeUrlPrefixOptionsAndParameters((String)this.url(), (String[])new String[]{JDBC_URL_PREFIX_FILE, JDBC_URL_PREFIX});
    }

    private boolean isEmbeddedInMemory() {
        return this.url().startsWith(JDBC_URL_PREFIX_MEM);
    }

    private boolean databaseFileExists() {
        return Files.exists(Paths.get(this.databasePath() + FILE_SUFFIX_PAGESTORE, new String[0]), new LinkOption[0]) || Files.exists(Paths.get(this.databasePath() + FILE_SUFFIX_MVSTORE, new String[0]), new LinkOption[0]);
    }

    private void initialize(Properties properties, String appendToUrl) {
        try {
            DriverManager.getConnection(this.url() + appendToUrl, properties).close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

