/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.derby;

import is.codion.common.db.database.Database;
import is.codion.common.db.database.DatabaseFactory;
import is.codion.dbms.derby.DerbyDatabase;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;

public final class DerbyDatabaseFactory
implements DatabaseFactory {
    private static final String DRIVER_PACKAGE = "org.apache.derby.jdbc";
    private static final String SHUTDOWN_ERROR_CODE = "08006";

    public boolean driverCompatible(String driverClassName) {
        return Objects.requireNonNull(driverClassName, "driverClassName").startsWith(DRIVER_PACKAGE);
    }

    public Database createDatabase(String url) {
        return new DerbyDatabase(url);
    }

    public static void shutdown(Database database) {
        block2: {
            Objects.requireNonNull(database);
            try {
                DriverManager.getConnection(database.url() + ";shutdown=true").close();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals(SHUTDOWN_ERROR_CODE)) break block2;
                System.err.println("Embedded Derby database did not successfully shut down: " + e.getMessage());
            }
        }
    }
}

