/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.derby;

import is.codion.common.db.database.AbstractDatabase;
import java.sql.SQLException;
import java.util.Objects;

final class DerbyDatabase
extends AbstractDatabase {
    private static final String TIMEOUT_ERROR_CODE = "XCL52";
    private static final int FOREIGN_KEY_ERROR = 23503;
    private static final String JDBC_URL_PREFIX_TCP = "jdbc:derby://";
    private static final String JDBC_URL_PREFIX_FILE = "jdbc:derby:";
    static final String AUTO_INCREMENT_QUERY = "SELECT IDENTITY_VAL_LOCAL() FROM ";

    DerbyDatabase(String url) {
        super(url);
    }

    public String name() {
        String name = this.url();
        boolean tcp = name.startsWith(JDBC_URL_PREFIX_TCP);
        name = DerbyDatabase.removeUrlPrefixOptionsAndParameters((String)name, (String[])new String[]{JDBC_URL_PREFIX_TCP, JDBC_URL_PREFIX_FILE});
        if (tcp && name.contains("/")) {
            name = name.substring(name.indexOf(47) + 1);
        }
        return name;
    }

    public String selectForUpdateClause() {
        return "FOR UPDATE";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return DerbyDatabase.createOffsetFetchNextClause((Integer)limit, (Integer)offset);
    }

    public String autoIncrementQuery(String idSource) {
        return AUTO_INCREMENT_QUERY + Objects.requireNonNull(idSource, "idSource");
    }

    public boolean isReferentialIntegrityException(SQLException exception) {
        return exception.getErrorCode() == 23503;
    }

    public boolean isTimeoutException(SQLException exception) {
        return TIMEOUT_ERROR_CODE.equals(exception.getSQLState());
    }
}

