/*
 * Decompiled with CFR 0.152.
 */
package is.codion.dbms.db2database;

import is.codion.common.db.database.AbstractDatabase;
import java.sql.SQLException;
import java.util.Objects;

final class Db2Database
extends AbstractDatabase {
    private static final int REFERENTIAL_INTEGRITY_INSERT_UPDATE = -530;
    private static final int REFERENTIAL_INTEGRITY_DELETE_1 = -532;
    private static final int REFERENTIAL_INTEGRITY_DELETE_2 = -536;
    private static final int UNIQUE_CONSTRAINT = -803;
    private static final int AUTHENTICATION_ERROR = -4214;
    private static final int TIMEOUT_ERROR_1 = -911;
    private static final int TIMEOUT_ERROR_2 = -913;
    private static final String JDBC_URL_PREFIX = "jdbc:db2:";

    Db2Database(String url) {
        super(url);
    }

    public String name() {
        String name = Db2Database.removeUrlPrefixOptionsAndParameters((String)this.url(), (String[])new String[]{JDBC_URL_PREFIX});
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        return name;
    }

    public String autoIncrementQuery(String idSource) {
        return "SELECT PREVIOUS VALUE FOR " + Objects.requireNonNull(idSource, "idSource");
    }

    public String sequenceQuery(String sequenceName) {
        return "SELECT NEXT VALUE FOR " + Objects.requireNonNull(sequenceName, "sequenceName");
    }

    public String selectForUpdateClause() {
        return "FOR UPDATE";
    }

    public String limitOffsetClause(Integer limit, Integer offset) {
        return Db2Database.createLimitOffsetClause((Integer)limit, (Integer)offset);
    }

    public boolean isReferentialIntegrityException(SQLException exception) {
        int errorCode = exception.getErrorCode();
        return errorCode == -530 || errorCode == -532 || errorCode == -536;
    }

    public boolean isUniqueConstraintException(SQLException exception) {
        return exception.getErrorCode() == -803;
    }

    public boolean isAuthenticationException(SQLException exception) {
        return exception.getErrorCode() == -4214;
    }

    public boolean isTimeoutException(SQLException exception) {
        int errorCode = exception.getErrorCode();
        return errorCode == -911 || errorCode == -913;
    }
}

