/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.Configuration;
import is.codion.common.Text;
import is.codion.common.property.PropertyValue;
import is.codion.common.rmi.server.DefaultServerConfiguration;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collection;
import java.util.function.Supplier;

public interface ServerConfiguration {
    public static final int DEFAULT_IDLE_CONNECTION_TIMEOUT = 120000;
    public static final int DEFAULT_CONNECTION_MAINTENANCE_INTERVAL = 30000;
    public static final String JAVAX_NET_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_NET_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String LOCALHOST = "localhost";
    public static final PropertyValue<String> RMI_SERVER_HOSTNAME = Configuration.stringValue((String)"java.rmi.server.hostname", (String)"localhost");
    public static final PropertyValue<String> SERVER_NAME_PREFIX = Configuration.stringValue((String)"codion.server.namePrefix", (String)"Codion Server");
    public static final PropertyValue<Integer> SERVER_PORT = Configuration.integerValue((String)"codion.server.port", (int)-1);
    public static final PropertyValue<Integer> REGISTRY_PORT = Configuration.integerValue((String)"codion.server.registryPort", (int)1099);
    public static final PropertyValue<String> CLASSPATH_KEYSTORE = Configuration.stringValue((String)"codion.server.classpathKeyStore");
    public static final PropertyValue<String> KEYSTORE = Configuration.stringValue((String)"javax.net.ssl.keyStore");
    public static final PropertyValue<String> KEYSTORE_PASSWORD = Configuration.stringValue((String)"javax.net.ssl.keyStorePassword");
    public static final PropertyValue<Integer> ADMIN_PORT = Configuration.integerValue((String)"codion.server.admin.port", (int)0);
    public static final PropertyValue<String> ADMIN_USER = Configuration.stringValue((String)"codion.server.admin.user");
    public static final PropertyValue<Boolean> SSL_ENABLED = Configuration.booleanValue((String)"codion.server.connection.sslEnabled", (boolean)true);
    public static final PropertyValue<Integer> IDLE_CONNECTION_TIMEOUT = Configuration.integerValue((String)"codion.server.idleConnectionTimeout", (int)120000);
    public static final PropertyValue<String> AUXILIARY_SERVER_FACTORY_CLASS_NAMES = Configuration.stringValue((String)"codion.server.auxiliaryServerFactoryClassNames");
    public static final PropertyValue<String> OBJECT_INPUT_FILTER_FACTORY_CLASS_NAME = Configuration.stringValue((String)"codion.server.objectInputFilterFactoryClassName");
    public static final PropertyValue<Integer> CONNECTION_MAINTENANCE_INTERVAL_MS = Configuration.integerValue((String)"codion.server.connectionMaintenanceIntervalMs", (int)30000);

    public String serverName();

    public int port();

    public int registryPort();

    public int adminPort();

    public Collection<String> auxiliaryServerFactoryClassNames();

    public boolean sslEnabled();

    public RMIClientSocketFactory rmiClientSocketFactory();

    public RMIServerSocketFactory rmiServerSocketFactory();

    public String objectInputFilterFactoryClassName();

    public int connectionMaintenanceInterval();

    public static <B extends Builder<B>> Builder<B> builder(int serverPort) {
        return new DefaultServerConfiguration.DefaultBuilder(serverPort, 1099);
    }

    public static <B extends Builder<B>> Builder<B> builder(int serverPort, int registryPort) {
        return new DefaultServerConfiguration.DefaultBuilder(serverPort, registryPort);
    }

    public static <B extends Builder<B>> Builder<B> builderFromSystemProperties() {
        return ServerConfiguration.builder((Integer)SERVER_PORT.getOrThrow(), (Integer)REGISTRY_PORT.getOrThrow()).auxiliaryServerFactoryClassNames(Text.parseCommaSeparatedValues((String)((String)AUXILIARY_SERVER_FACTORY_CLASS_NAMES.get()))).adminPort((Integer)ADMIN_PORT.get()).sslEnabled((Boolean)SSL_ENABLED.get()).connectionMaintenanceIntervalMs((Integer)CONNECTION_MAINTENANCE_INTERVAL_MS.get()).objectInputFilterFactoryClassName((String)OBJECT_INPUT_FILTER_FACTORY_CLASS_NAME.get());
    }

    public static interface Builder<B extends Builder<B>> {
        public B adminPort(int var1);

        public B serverName(Supplier<String> var1);

        public B serverName(String var1);

        public B auxiliaryServerFactoryClassNames(Collection<String> var1);

        public B sslEnabled(boolean var1);

        public B rmiClientSocketFactory(RMIClientSocketFactory var1);

        public B rmiServerSocketFactory(RMIServerSocketFactory var1);

        public B objectInputFilterFactoryClassName(String var1);

        public B connectionMaintenanceIntervalMs(int var1);

        public ServerConfiguration build();
    }
}

