/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import java.io.ObjectInputFilter;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface ObjectInputFilterFactory {
    public ObjectInputFilter createObjectInputFilter();

    public static ObjectInputFilterFactory instance(String classname) {
        Objects.requireNonNull(classname, "classname");
        try {
            ServiceLoader<ObjectInputFilterFactory> loader = ServiceLoader.load(ObjectInputFilterFactory.class);
            for (ObjectInputFilterFactory factory : loader) {
                if (!factory.getClass().getName().equals(classname)) continue;
                return factory;
            }
            throw new IllegalStateException("No object input filter factory of type: " + classname + " available");
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

