/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.rmi.server.Server;
import is.codion.common.rmi.server.ServerAdmin;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.rmi.server.ServerInformation;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultServerLocator
implements Server.Locator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServerLocator.class);
    private final String hostName;
    private final String namePrefix;
    private final int registryPort;
    private final int port;

    private DefaultServerLocator(DefaultBuilder builder) {
        this.hostName = Objects.requireNonNull(builder.hostName, "hostName");
        this.namePrefix = Objects.requireNonNull(builder.namePrefix, "namePrefix");
        this.registryPort = builder.registryPort;
        this.port = builder.port;
    }

    public <T extends Remote, A extends ServerAdmin> Server<T, A> locateServer() throws RemoteException, NotBoundException {
        List<Server<T, A>> servers = DefaultServerLocator.findServers(this.hostName, this.registryPort, this.namePrefix, this.port);
        if (!servers.isEmpty()) {
            return servers.get(0);
        }
        throw new NotBoundException("'" + this.namePrefix + "' is not available, see LOG for details. Host: " + this.hostName + (String)(this.port != -1 ? ", port: " + this.port : "") + ", registryPort: " + this.registryPort);
    }

    static Registry initializeRegistry(int registryPort) throws RemoteException {
        LOG.info("Initializing registry on port: {}", (Object)registryPort);
        Registry localRegistry = LocateRegistry.getRegistry(registryPort);
        try {
            localRegistry.list();
            LOG.info("Registry listing available on port: {}", (Object)registryPort);
            return localRegistry;
        }
        catch (Exception e) {
            LOG.info("Trying to locate registry: {}", (Object)e.getMessage());
            LOG.info("Creating registry on port: {}", (Object)registryPort);
            return LocateRegistry.createRegistry(registryPort);
        }
    }

    private static <T extends Remote, A extends ServerAdmin> List<Server<T, A>> findServers(String hostNames, int registryPort, String serverNamePrefix, int requestedServerPort) throws RemoteException {
        ArrayList<Server<T, A>> servers = new ArrayList<Server<T, A>>();
        for (String hostName : hostNames.split(",")) {
            servers.addAll(DefaultServerLocator.findServersOnHost(hostName, registryPort, serverNamePrefix, requestedServerPort));
        }
        servers.sort(new ServerComparator());
        return servers;
    }

    private static <T extends Remote, A extends ServerAdmin> List<Server<T, A>> findServersOnHost(String hostName, int registryPort, String serverNamePrefix, int requestedServerPort) throws RemoteException {
        LOG.info("Searching for servers,  host: \"{}\", server name prefix: \"{}\", requested server port: {}, registry port {}", new Object[]{hostName, serverNamePrefix, requestedServerPort, registryPort});
        ArrayList<Server<T, A>> servers = new ArrayList<Server<T, A>>();
        Registry registry = LocateRegistry.getRegistry(hostName, registryPort);
        for (String serverName : registry.list()) {
            if (!serverName.startsWith(serverNamePrefix)) continue;
            DefaultServerLocator.addIfReachable(serverName, requestedServerPort, registry, servers);
        }
        return servers;
    }

    private static <T extends Remote, A extends ServerAdmin> void addIfReachable(String serverName, int requestedServerPort, Registry registry, List<Server<T, A>> servers) {
        LOG.info("Found server \"{}\"", (Object)serverName);
        try {
            Server<T, A> server = DefaultServerLocator.getIfReachable((Server)registry.lookup(serverName), requestedServerPort);
            if (server != null) {
                LOG.info("Adding server \"{}\"", (Object)serverName);
                servers.add(server);
            }
        }
        catch (Exception e) {
            LOG.error("Server \"{}\" is unreachable", (Object)serverName, (Object)e);
        }
    }

    private static <T extends Remote, A extends ServerAdmin> Server<T, A> getIfReachable(Server<T, A> server, int requestedServerPort) throws RemoteException {
        ServerInformation serverInformation = server.serverInformation();
        if (requestedServerPort != -1 && serverInformation.serverPort() != requestedServerPort) {
            LOG.warn("Server \"{}\" is serving on port {}, requested port was {}", new Object[]{serverInformation.serverName(), serverInformation.serverPort(), requestedServerPort});
            return null;
        }
        if (server.connectionsAvailable()) {
            return server;
        }
        LOG.warn("No connections available in server \"{}\"", (Object)serverInformation.serverName());
        return null;
    }

    static final class DefaultBuilder
    implements Server.Locator.Builder {
        private String hostName = (String)ServerConfiguration.RMI_SERVER_HOSTNAME.get();
        private String namePrefix = (String)ServerConfiguration.SERVER_NAME_PREFIX.get();
        private int registryPort = (Integer)ServerConfiguration.REGISTRY_PORT.get();
        private int port = (Integer)ServerConfiguration.SERVER_PORT.get();

        DefaultBuilder() {
        }

        @Override
        public Server.Locator.Builder hostName(String hostName) {
            this.hostName = Objects.requireNonNull(hostName);
            return this;
        }

        @Override
        public Server.Locator.Builder namePrefix(String namePrefix) {
            this.namePrefix = Objects.requireNonNull(namePrefix);
            return this;
        }

        @Override
        public Server.Locator.Builder registryPort(int registryPort) {
            this.registryPort = registryPort;
            return this;
        }

        @Override
        public Server.Locator.Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public Server.Locator build() {
            return new DefaultServerLocator(this);
        }
    }

    private static final class ServerComparator<T extends Remote, A extends ServerAdmin>
    implements Comparator<Server<T, A>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ServerComparator() {
        }

        @Override
        public int compare(Server<T, A> o1, Server<T, A> o2) {
            try {
                return Integer.compare(o1.serverLoad(), o2.serverLoad());
            }
            catch (RemoteException e) {
                return 1;
            }
        }
    }
}

