/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

final class DefaultRemoteClient
implements RemoteClient,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ConnectionRequest connectionRequest;
    private final User databaseUser;
    private final String clientHost;
    private final LocalDateTime creationTime;

    DefaultRemoteClient(ConnectionRequest connectionRequest, User databaseUser, String clientHost) {
        this(connectionRequest, databaseUser, clientHost, LocalDateTime.now());
    }

    DefaultRemoteClient(ConnectionRequest connectionRequest, User databaseUser, String clientHost, LocalDateTime creationTime) {
        this.connectionRequest = Objects.requireNonNull(connectionRequest, "connectionRequest");
        this.databaseUser = Objects.requireNonNull(databaseUser, "databaseUser");
        this.clientHost = clientHost;
        this.creationTime = creationTime;
    }

    @Override
    public ConnectionRequest connectionRequest() {
        return this.connectionRequest;
    }

    @Override
    public LocalDateTime creationTime() {
        return this.creationTime;
    }

    @Override
    public User user() {
        return this.connectionRequest.user();
    }

    @Override
    public User databaseUser() {
        return this.databaseUser;
    }

    @Override
    public UUID clientId() {
        return this.connectionRequest.clientId();
    }

    @Override
    public String clientTypeId() {
        return this.connectionRequest.clientTypeId();
    }

    @Override
    public Locale clientLocale() {
        return this.connectionRequest.clientLocale();
    }

    @Override
    public ZoneId clientTimeZone() {
        return this.connectionRequest.clientTimeZone();
    }

    @Override
    public Version clientVersion() {
        return this.connectionRequest.clientVersion();
    }

    @Override
    public Version frameworkVersion() {
        return this.connectionRequest.frameworkVersion();
    }

    @Override
    public Map<String, Object> parameters() {
        return this.connectionRequest.parameters();
    }

    @Override
    public String clientHost() {
        return this.clientHost;
    }

    @Override
    public RemoteClient withDatabaseUser(User databaseUser) {
        return new DefaultRemoteClient(this.connectionRequest, databaseUser, this.clientHost, this.creationTime);
    }

    @Override
    public RemoteClient copy() {
        return new DefaultRemoteClient(this.connectionRequest.copy(), this.databaseUser.copy(), this.clientHost, this.creationTime);
    }

    public int hashCode() {
        return this.connectionRequest.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RemoteClient && this.connectionRequest.equals(((RemoteClient)obj).connectionRequest());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.connectionRequest.user().toString());
        if (this.databaseUser != null && !this.connectionRequest.user().equals(this.databaseUser)) {
            builder.append(" (databaseUser: ").append(this.databaseUser).append(")");
        }
        builder.append("@").append(this.clientHost == null ? "unknown" : this.clientHost).append(" [").append(this.connectionRequest.clientTypeId()).append((String)(this.connectionRequest.clientVersion() != null ? "-" + this.connectionRequest.clientVersion() : "")).append("] - ").append(this.connectionRequest.clientId().toString());
        return builder.toString();
    }
}

