/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputFilter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SerializationWhitelist {
    private static final Logger LOG = LoggerFactory.getLogger(SerializationWhitelist.class);
    private static final String CLASSPATH_PREFIX = "classpath:";

    private SerializationWhitelist() {
    }

    static WhitelistFilter whitelistFilter(String whitelistFile) {
        return new WhitelistFilter(whitelistFile);
    }

    static WhitelistFilter whitelistFilter(Collection<String> classnames) {
        return new WhitelistFilter(classnames);
    }

    static DryRun whitelistDryRun() {
        return new DryRun();
    }

    static final class WhitelistFilter
    implements ObjectInputFilter {
        private static final String COMMENT = "#";
        private static final String WILDCARD = "*";
        private final Set<String> allowedClassnames = new HashSet<String>();
        private final List<String> allowedWildcardClassnames = new ArrayList<String>();

        private WhitelistFilter(String whitelistFile) {
            this(WhitelistFilter.readWhitelistItems(whitelistFile));
        }

        private WhitelistFilter(Collection<String> whitelistItems) {
            this.addWhitelistItems(whitelistItems);
        }

        @Override
        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
            Class<?> clazz = filterInfo.serialClass();
            if (clazz == null) {
                return ObjectInputFilter.Status.ALLOWED;
            }
            return this.checkInput(clazz.getName());
        }

        ObjectInputFilter.Status checkInput(String classname) {
            if (this.allowedClassnames.contains(classname) || this.allowWildcard(classname)) {
                return ObjectInputFilter.Status.ALLOWED;
            }
            LOG.error("Serialization rejected: " + classname);
            return ObjectInputFilter.Status.REJECTED;
        }

        private void addWhitelistItems(Collection<String> whitelistItems) {
            Objects.requireNonNull(whitelistItems).forEach(whitelistItem -> {
                if (!whitelistItem.startsWith(COMMENT)) {
                    if (whitelistItem.endsWith(WILDCARD)) {
                        this.allowedWildcardClassnames.add(whitelistItem.substring(0, whitelistItem.length() - 1));
                    } else {
                        this.allowedClassnames.add((String)whitelistItem);
                    }
                }
            });
        }

        private boolean allowWildcard(String classname) {
            if (this.allowedWildcardClassnames.isEmpty()) {
                return false;
            }
            for (int i = 0; i < this.allowedWildcardClassnames.size(); ++i) {
                if (!classname.startsWith(this.allowedWildcardClassnames.get(i))) continue;
                return true;
            }
            return false;
        }

        private static Collection<String> readWhitelistItems(String whitelistFile) {
            if (Objects.requireNonNull(whitelistFile).startsWith(SerializationWhitelist.CLASSPATH_PREFIX)) {
                return WhitelistFilter.readClasspathWhitelistItems(whitelistFile);
            }
            return WhitelistFilter.readFileWhitelistItems(whitelistFile);
        }

        private static Collection<String> readClasspathWhitelistItems(String whitelistFile) {
            Collection collection;
            block9: {
                String path = WhitelistFilter.classpathFilepath(whitelistFile);
                InputStream whitelistFileStream = SerializationWhitelist.class.getClassLoader().getResourceAsStream(path);
                try {
                    if (whitelistFileStream == null) {
                        throw new RuntimeException("Whitelist file not found on classpath: " + path);
                    }
                    collection = new BufferedReader(new InputStreamReader(whitelistFileStream, StandardCharsets.UTF_8)).lines().collect(Collectors.toSet());
                    if (whitelistFileStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (whitelistFileStream != null) {
                            try {
                                whitelistFileStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to load whitelist from classpath: " + whitelistFile, e);
                    }
                }
                whitelistFileStream.close();
            }
            return collection;
        }

        private static Collection<String> readFileWhitelistItems(String whitelistFile) {
            Collection collection;
            block8: {
                Stream<String> stream = Files.lines(Paths.get(whitelistFile, new String[0]));
                try {
                    collection = stream.collect(Collectors.toSet());
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.error("Unable to read serialization whitelist: " + whitelistFile);
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return collection;
        }

        private static String classpathFilepath(String whitelistFile) {
            String path = whitelistFile.substring(SerializationWhitelist.CLASSPATH_PREFIX.length());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.contains("/")) {
                throw new IllegalArgumentException("Whitelist file must be in the classpath root");
            }
            return path;
        }
    }

    static final class DryRun
    implements ObjectInputFilter {
        private final Set<Class<?>> deserializedClasses = new HashSet();

        DryRun() {
        }

        @Override
        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
            Class<?> clazz = filterInfo.serialClass();
            if (clazz != null) {
                this.deserializedClasses.add(clazz);
            }
            return ObjectInputFilter.Status.ALLOWED;
        }

        synchronized void writeToFile(String whitelistFile) {
            if (Objects.requireNonNull(whitelistFile).toLowerCase().startsWith(SerializationWhitelist.CLASSPATH_PREFIX)) {
                throw new IllegalArgumentException("Filter dry run can not be performed with a classpath whitelist: " + whitelistFile);
            }
            try {
                Files.write(Paths.get(whitelistFile, new String[0]), (Iterable<? extends CharSequence>)this.deserializedClasses.stream().map(Class::getName).sorted().collect(Collectors.toList()), StandardOpenOption.CREATE);
                LOG.debug("Serialization whitelist written: " + whitelistFile);
            }
            catch (Exception e) {
                LOG.error("Error while writing serialization filter dry run results: " + whitelistFile, (Throwable)e);
            }
        }
    }
}

