/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.rmi.server.ServerInformation;
import is.codion.common.version.Version;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.UUID;

final class DefaultServerInformation
implements ServerInformation,
Serializable {
    private static final long serialVersionUID = 1L;
    private final UUID serverId;
    private final String serverName;
    private final int serverPort;
    private final ZonedDateTime serverStartTime;
    private final Locale locale = Locale.getDefault();
    private final Version serverVersion = Version.version();

    DefaultServerInformation(UUID serverId, String serverName, int serverPort, ZonedDateTime serverStartTime) {
        this.serverId = serverId;
        this.serverName = serverName;
        this.serverPort = serverPort;
        this.serverStartTime = serverStartTime;
    }

    @Override
    public String serverName() {
        return this.serverName;
    }

    @Override
    public UUID serverId() {
        return this.serverId;
    }

    @Override
    public int serverPort() {
        return this.serverPort;
    }

    @Override
    public Version serverVersion() {
        return this.serverVersion;
    }

    @Override
    public ZonedDateTime startTime() {
        return this.serverStartTime;
    }

    @Override
    public Locale locale() {
        return this.locale;
    }

    @Override
    public ZoneId timeZone() {
        return this.serverStartTime.getZone();
    }
}

