/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.OperatingSystemMXBean;
import is.codion.common.Memory;
import is.codion.common.Separators;
import is.codion.common.property.PropertyStore;
import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.rmi.server.AbstractServer;
import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.rmi.server.ServerAdmin;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.rmi.server.ServerInformation;
import is.codion.common.user.User;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerAdmin
extends UnicastRemoteObject
implements ServerAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServerAdmin.class);
    private static final long serialVersionUID = 1L;
    private static final int GC_INFO_MAX_LENGTH = 100;
    private final transient AbstractServer<?, ? extends ServerAdmin> server;
    private final transient LinkedList<ServerAdmin.GcEvent> gcEventList = new LinkedList();
    private final transient PropertyStore.PropertyFormatter propertyFormatter = new SystemPropertyFormatter();

    public DefaultServerAdmin(AbstractServer<?, ? extends ServerAdmin> server, ServerConfiguration configuration) throws RemoteException {
        super(Objects.requireNonNull(configuration, "configuration").adminPort(), configuration.rmiClientSocketFactory(), configuration.rmiServerSocketFactory());
        this.server = Objects.requireNonNull(server, "server");
        this.initializeGarbageCollectionListener();
    }

    @Override
    public final ServerInformation serverInformation() {
        return this.server.serverInformation();
    }

    @Override
    public final String systemProperties() {
        return PropertyStore.systemProperties((PropertyStore.PropertyFormatter)this.propertyFormatter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<ServerAdmin.GcEvent> gcEvents(long since) {
        LinkedList<ServerAdmin.GcEvent> gcEvents;
        LinkedList<ServerAdmin.GcEvent> linkedList = this.gcEventList;
        synchronized (linkedList) {
            gcEvents = new LinkedList<ServerAdmin.GcEvent>(this.gcEventList);
        }
        gcEvents.removeIf(gcEvent -> gcEvent.timestamp() < since);
        return gcEvents;
    }

    @Override
    public final ServerAdmin.ThreadStatistics threadStatistics() throws RemoteException {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        EnumMap<Thread.State, Integer> threadStateMap = new EnumMap<Thread.State, Integer>(Thread.State.class);
        long[] lArray = bean.getAllThreadIds();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long threadId = lArray[i];
            threadStateMap.compute(bean.getThreadInfo(threadId).getThreadState(), (threadState, value) -> value == null ? 1 : value + 1);
        }
        return new DefaultThreadStatistics(bean.getThreadCount(), bean.getDaemonThreadCount(), threadStateMap);
    }

    @Override
    public final Collection<User> users() throws RemoteException {
        return this.server.users();
    }

    @Override
    public final Collection<RemoteClient> clients(User user) throws RemoteException {
        return this.server.clients(user);
    }

    @Override
    public final Collection<RemoteClient> clients(String clientTypeId) {
        return this.server.clients(clientTypeId);
    }

    @Override
    public final Collection<RemoteClient> clients() {
        return this.server.clients();
    }

    @Override
    public final Collection<String> clientTypes() {
        return this.clients().stream().map(ConnectionRequest::clientTypeId).collect(Collectors.toSet());
    }

    @Override
    public final void disconnect(UUID clientId) throws RemoteException {
        LOG.info("disconnect({})", (Object)clientId);
        this.server.disconnect(clientId);
    }

    @Override
    public final void shutdown() throws RemoteException {
        this.server.shutdown();
    }

    @Override
    public int requestsPerSecond() {
        return -1;
    }

    @Override
    public final ServerAdmin.ServerStatistics serverStatistics(long since) throws RemoteException {
        return new DefaultServerStatistics(System.currentTimeMillis(), this.connectionCount(), this.getConnectionLimit(), this.usedMemory(), this.maxMemory(), this.allocatedMemory(), this.requestsPerSecond(), this.systemCpuLoad(), this.processCpuLoad(), this.threadStatistics(), this.gcEvents(since));
    }

    @Override
    public final long allocatedMemory() {
        return Memory.allocatedMemory();
    }

    @Override
    public final long usedMemory() {
        return Memory.usedMemory();
    }

    @Override
    public final long maxMemory() {
        return Memory.maxMemory();
    }

    @Override
    public final double systemCpuLoad() throws RemoteException {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getSystemCpuLoad();
    }

    @Override
    public final double processCpuLoad() throws RemoteException {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuLoad();
    }

    @Override
    public final int connectionCount() {
        return this.server.connectionCount();
    }

    @Override
    public final int getConnectionLimit() {
        return this.server.getConnectionLimit();
    }

    @Override
    public final void setConnectionLimit(int value) {
        LOG.info("setConnectionLimit({})", (Object)value);
        this.server.setConnectionLimit(value);
    }

    private void initializeGarbageCollectionListener() {
        for (GarbageCollectorMXBean collectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            ((NotificationEmitter)((Object)collectorMXBean)).addNotificationListener(new GcNotificationListener(), notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
        }
    }

    private static final class SystemPropertyFormatter
    implements PropertyStore.PropertyFormatter {
        private SystemPropertyFormatter() {
        }

        public String formatValue(String property, String value) {
            if (SystemPropertyFormatter.classOrModulePath(property) && !value.isEmpty()) {
                return "\n" + String.join((CharSequence)"\n", value.split(Separators.PATH_SEPARATOR));
            }
            return value;
        }

        private static boolean classOrModulePath(String property) {
            return property.endsWith("class.path") || property.endsWith("module.path");
        }
    }

    private static final class DefaultThreadStatistics
    implements ServerAdmin.ThreadStatistics,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int threadCount;
        private final int daemonThreadCount;
        private final Map<Thread.State, Integer> threadStateCount;

        private DefaultThreadStatistics(int threadCount, int daemonThreadCount, Map<Thread.State, Integer> threadStateCount) {
            this.threadCount = threadCount;
            this.daemonThreadCount = daemonThreadCount;
            this.threadStateCount = threadStateCount;
        }

        @Override
        public int threadCount() {
            return this.threadCount;
        }

        @Override
        public int daemonThreadCount() {
            return this.daemonThreadCount;
        }

        @Override
        public Map<Thread.State, Integer> threadStateCount() {
            return this.threadStateCount;
        }
    }

    private static final class DefaultServerStatistics
    implements ServerAdmin.ServerStatistics,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long timestamp;
        private final int connectionCount;
        private final int connectionLimit;
        private final long usedMemory;
        private final long maximumMemory;
        private final long allocatedMemory;
        private final int requestsPerSecond;
        private final double systemCpuLoad;
        private final double processCpuLoad;
        private final ServerAdmin.ThreadStatistics threadStatistics;
        private final List<ServerAdmin.GcEvent> gcEvents;

        private DefaultServerStatistics(long timestamp, int connectionCount, int connectionLimit, long usedMemory, long maximumMemory, long allocatedMemory, int requestsPerSecond, double systemCpuLoad, double processCpuLoad, ServerAdmin.ThreadStatistics threadStatistics, List<ServerAdmin.GcEvent> gcEvents) {
            this.timestamp = timestamp;
            this.connectionCount = connectionCount;
            this.connectionLimit = connectionLimit;
            this.usedMemory = usedMemory;
            this.maximumMemory = maximumMemory;
            this.allocatedMemory = allocatedMemory;
            this.requestsPerSecond = requestsPerSecond;
            this.systemCpuLoad = systemCpuLoad;
            this.processCpuLoad = processCpuLoad;
            this.threadStatistics = threadStatistics;
            this.gcEvents = gcEvents;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public int connectionCount() {
            return this.connectionCount;
        }

        @Override
        public int connectionLimit() {
            return this.connectionLimit;
        }

        @Override
        public long usedMemory() {
            return this.usedMemory;
        }

        @Override
        public long maximumMemory() {
            return this.maximumMemory;
        }

        @Override
        public long allocatedMemory() {
            return this.allocatedMemory;
        }

        @Override
        public int requestsPerSecond() {
            return this.requestsPerSecond;
        }

        @Override
        public double systemCpuLoad() {
            return this.systemCpuLoad;
        }

        @Override
        public double processCpuLoad() {
            return this.processCpuLoad;
        }

        @Override
        public ServerAdmin.ThreadStatistics threadStatistics() {
            return this.threadStatistics;
        }

        @Override
        public List<ServerAdmin.GcEvent> gcEvents() {
            return this.gcEvents;
        }
    }

    private final class GcNotificationListener
    implements NotificationListener {
        private GcNotificationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification notification, Object handback) {
            LinkedList<ServerAdmin.GcEvent> linkedList = DefaultServerAdmin.this.gcEventList;
            synchronized (linkedList) {
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                DefaultServerAdmin.this.gcEventList.addLast(new DefaultGcEvent(notification.getTimeStamp(), notificationInfo.getGcName(), notificationInfo.getGcInfo().getDuration()));
                if (DefaultServerAdmin.this.gcEventList.size() > 100) {
                    DefaultServerAdmin.this.gcEventList.removeFirst();
                }
            }
        }
    }

    private static class DefaultGcEvent
    implements ServerAdmin.GcEvent,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long timestamp;
        private final String gcName;
        private final long duration;

        private DefaultGcEvent(long timestamp, String gcName, long duration) {
            this.timestamp = timestamp;
            this.gcName = gcName;
            this.duration = duration;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public String gcName() {
            return this.gcName;
        }

        @Override
        public long duration() {
            return this.duration;
        }
    }
}

