/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.table;

import is.codion.common.model.table.ColumnSummary;
import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

final class DefaultColumnSummaryModel<T extends Number>
implements ColumnSummaryModel {
    private final Value<? extends ColumnSummaryModel.Summary> summary = Value.builder().nonNull((Object)ColumnSummary.NONE).listener(this::updateSummary).build();
    private final Value<String> summaryText = Value.value();
    private final State locked = State.state();
    private final ColumnSummaryModel.SummaryValues<T> summaryValues;
    private final List<ColumnSummaryModel.Summary> summaries = Arrays.asList(ColumnSummary.values());

    DefaultColumnSummaryModel(ColumnSummaryModel.SummaryValues<T> summaryValues) {
        this.summaryValues = Objects.requireNonNull(summaryValues);
        this.summary.addValidator(summary -> {
            if (((Boolean)this.locked.get()).booleanValue()) {
                throw new IllegalStateException("Summary model is locked");
            }
        });
        this.summaryValues.changeEvent().addListener(this::updateSummary);
    }

    @Override
    public State locked() {
        return this.locked;
    }

    @Override
    public Value<ColumnSummaryModel.Summary> summary() {
        return this.summary;
    }

    @Override
    public List<ColumnSummaryModel.Summary> summaries() {
        return this.summaries;
    }

    @Override
    public ValueObserver<String> summaryText() {
        return this.summaryText.observer();
    }

    private void updateSummary() {
        this.summaryText.set((Object)((ColumnSummaryModel.Summary)this.summary().get()).summary(this.summaryValues));
    }
}

