/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.randomizer;

import is.codion.common.model.randomizer.ItemRandomizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;

class DefaultItemRandomizer<T>
implements ItemRandomizer<T> {
    private final List<ItemRandomizer.RandomItem<T>> items;
    private final Random random = new Random();

    DefaultItemRandomizer(Collection<ItemRandomizer.RandomItem<T>> items) {
        this.items = Collections.unmodifiableList(new ArrayList<ItemRandomizer.RandomItem<T>>(Objects.requireNonNull(items)));
    }

    @Override
    public void incrementWeight(T item) {
        this.randomItem(item).incrementWeight();
    }

    @Override
    public void decrementWeight(T item) {
        this.randomItem(item).decrementWeight();
    }

    @Override
    public void setWeight(T item, int weight) {
        this.randomItem(item).setWeight(weight);
    }

    @Override
    public final boolean isItemEnabled(T item) {
        return this.randomItem(item).isEnabled();
    }

    @Override
    public final void setItemEnabled(T item, boolean enabled) {
        this.randomItem(item).setEnabled(enabled);
    }

    @Override
    public final List<ItemRandomizer.RandomItem<T>> items() {
        return this.items;
    }

    @Override
    public final int itemCount() {
        return this.items.size();
    }

    @Override
    public final T randomItem() {
        int totalWeights = this.totalWeights();
        if (totalWeights == 0) {
            throw new IllegalStateException("Can not choose a random item unless total weights exceed 0");
        }
        int randomNumber = this.random.nextInt(totalWeights + 1);
        int position = 0;
        for (ItemRandomizer.RandomItem<T> item : this.items) {
            if (randomNumber > (position += item.weight()) || item.weight() <= 0) continue;
            return item.item();
        }
        throw new IllegalStateException("randomItem() did not find an item");
    }

    @Override
    public final double weightRatio(T item) {
        int totalWeights = this.totalWeights();
        if (totalWeights == 0) {
            return 0.0;
        }
        return (double)this.weight(item) / (double)totalWeights;
    }

    @Override
    public final int weight(T item) {
        return this.randomItem(item).weight();
    }

    protected final ItemRandomizer.RandomItem<T> randomItem(T item) {
        Objects.requireNonNull(item);
        for (ItemRandomizer.RandomItem<T> randomItem : this.items) {
            if (randomItem.item() != item) continue;
            return randomItem;
        }
        throw new IllegalArgumentException("Item not found: " + item + ": " + item.getClass());
    }

    private int totalWeights() {
        return this.items.stream().mapToInt(ItemRandomizer.RandomItem::weight).sum();
    }
}

