/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model;

import java.util.Objects;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public final class UserPreferences {
    private static final String KEY = "key";
    private static Preferences preferences;

    private UserPreferences() {
    }

    public static String getUserPreference(String key, String defaultValue) {
        return UserPreferences.userPreferences().get(Objects.requireNonNull(key, KEY), defaultValue);
    }

    public static void setUserPreference(String key, String value) {
        UserPreferences.userPreferences().put(Objects.requireNonNull(key, KEY), value);
    }

    public static void removeUserPreference(String key) {
        UserPreferences.userPreferences().remove(Objects.requireNonNull(key, KEY));
    }

    public static void flushUserPreferences() throws BackingStoreException {
        UserPreferences.userPreferences().flush();
    }

    private static synchronized Preferences userPreferences() {
        if (preferences == null) {
            preferences = Preferences.userRoot();
        }
        return preferences;
    }
}

