/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.loadtest;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.model.loadtest.LoadTest;
import is.codion.common.model.randomizer.ItemRandomizer;
import is.codion.common.state.State;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultLoadTest<T>
implements LoadTest<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLoadTest.class);
    private static final Random RANDOM = new Random();
    private static final int MINIMUM_NUMBER_OF_THREADS = 12;
    private final Function<User, T> applicationFactory;
    private final Consumer<T> closeApplication;
    private final State paused = State.state();
    private final Value<Integer> loginDelayFactor;
    private final Value<Integer> applicationBatchSize;
    private final Value<Integer> maximumThinkTime;
    private final Value<Integer> minimumThinkTime;
    private final Value<Integer> applicationCount = Value.nullable((Object)0).build();
    private final Event<?> shutdownEvent = Event.event();
    private final Event<LoadTest.Scenario.Result> resultEvent = Event.event();
    private final String name;
    private final Value<User> user;
    private final Map<LoadTest.ApplicationRunner, T> applications = new HashMap<LoadTest.ApplicationRunner, T>();
    private final Map<String, LoadTest.Scenario<T>> scenarios;
    private final ItemRandomizer<LoadTest.Scenario<T>> scenarioChooser;
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(Math.max(12, Runtime.getRuntime().availableProcessors() * 2));

    DefaultLoadTest(DefaultBuilder<T> builder) {
        this.applicationFactory = builder.applicationFactory;
        this.closeApplication = builder.closeApplication;
        this.name = builder.name;
        this.user = Value.nonNull((Object)builder.user).build();
        this.loginDelayFactor = Value.nonNull((Object)builder.loginDelayFactor).validator((Value.Validator)new MinimumValidator(1)).build();
        this.applicationBatchSize = Value.nonNull((Object)builder.applicationBatchSize).validator((Value.Validator)new MinimumValidator(1)).build();
        this.minimumThinkTime = Value.nonNull((Object)builder.minimumThinkTime).build();
        this.maximumThinkTime = Value.nonNull((Object)builder.maximumThinkTime).build();
        this.minimumThinkTime.addValidator((Value.Validator)new MinimumThinkTimeValidator());
        this.maximumThinkTime.addValidator((Value.Validator)new MaximumThinkTimeValidator());
        this.scenarios = Collections.unmodifiableMap(builder.scenarios.stream().collect(Collectors.toMap(LoadTest.Scenario::name, Function.identity())));
        this.scenarioChooser = this.createScenarioChooser();
    }

    @Override
    public Value<User> user() {
        return this.user;
    }

    @Override
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public LoadTest.Scenario<T> scenario(String scenarioName) {
        LoadTest.Scenario<T> scenario = this.scenarios.get(Objects.requireNonNull(scenarioName));
        if (scenario == null) {
            throw new IllegalArgumentException("Scenario not found: " + scenarioName);
        }
        return scenario;
    }

    @Override
    public Collection<LoadTest.Scenario<T>> scenarios() {
        return this.scenarios.values();
    }

    @Override
    public void setWeight(String scenarioName, int weight) {
        this.scenarioChooser.setWeight(this.scenario(scenarioName), weight);
    }

    @Override
    public boolean isScenarioEnabled(String scenarioName) {
        return this.scenarioChooser.isItemEnabled(this.scenario(scenarioName));
    }

    @Override
    public void setScenarioEnabled(String scenarioName, boolean enabled) {
        this.scenarioChooser.setItemEnabled(this.scenario(scenarioName), enabled);
    }

    @Override
    public ItemRandomizer<LoadTest.Scenario<T>> scenarioChooser() {
        return this.scenarioChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<LoadTest.ApplicationRunner, T> applications() {
        Map<LoadTest.ApplicationRunner, T> map = this.applications;
        synchronized (map) {
            return new HashMap<LoadTest.ApplicationRunner, T>(this.applications);
        }
    }

    @Override
    public Value<Integer> applicationBatchSize() {
        return this.applicationBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationBatch() {
        Map<LoadTest.ApplicationRunner, T> map = this.applications;
        synchronized (map) {
            int batchSize = (Integer)this.applicationBatchSize.get();
            for (int i = 0; i < batchSize; ++i) {
                DefaultApplicationRunner applicationRunner = new DefaultApplicationRunner((User)this.user.get(), this.applicationFactory);
                this.applications.put(applicationRunner, applicationRunner.application);
                this.applicationCount.set((Object)this.applications.size());
                this.scheduledExecutor.schedule(applicationRunner, (long)this.initialDelay(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationBatch() {
        Map<LoadTest.ApplicationRunner, T> map = this.applications;
        synchronized (map) {
            if (!this.applications.isEmpty()) {
                this.applications.keySet().stream().filter(applicationRunner -> !applicationRunner.stopped()).limit(((Integer)this.applicationBatchSize.get()).intValue()).collect(Collectors.toList()).forEach(this::stop);
            }
        }
    }

    @Override
    public State paused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<LoadTest.ApplicationRunner, T> map = this.applications;
        synchronized (map) {
            new ArrayList<LoadTest.ApplicationRunner>(this.applications.keySet()).forEach(this::stop);
        }
        this.scheduledExecutor.shutdown();
        try {
            this.scheduledExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.shutdownEvent.run();
    }

    @Override
    public Value<Integer> maximumThinkTime() {
        return this.maximumThinkTime;
    }

    @Override
    public Value<Integer> minimumThinkTime() {
        return this.minimumThinkTime;
    }

    @Override
    public Value<Integer> loginDelayFactor() {
        return this.loginDelayFactor;
    }

    @Override
    public ValueObserver<Integer> applicationCount() {
        return this.applicationCount.observer();
    }

    @Override
    public void addShutdownListener(Runnable listener) {
        this.shutdownEvent.addListener(listener);
    }

    @Override
    public EventObserver<LoadTest.Scenario.Result> resultEvent() {
        return this.resultEvent.observer();
    }

    private int initialDelay() {
        int time = (Integer)this.maximumThinkTime.get() - (Integer)this.minimumThinkTime.get();
        return time > 0 ? RANDOM.nextInt(time * (Integer)this.loginDelayFactor.get()) + (Integer)this.minimumThinkTime.get() : (Integer)this.minimumThinkTime.get();
    }

    private ItemRandomizer<LoadTest.Scenario<T>> createScenarioChooser() {
        return ItemRandomizer.itemRandomizer(this.scenarios.values().stream().map(scenario -> ItemRandomizer.RandomItem.randomItem(scenario, scenario.defaultWeight())).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(LoadTest.ApplicationRunner applicationRunner) {
        Objects.requireNonNull(applicationRunner).stop();
        Map<LoadTest.ApplicationRunner, T> map = this.applications;
        synchronized (map) {
            this.applications.remove(applicationRunner);
            this.applicationCount.set((Object)this.applications.size());
        }
    }

    static final class DefaultBuilder<T>
    implements LoadTest.Builder<T> {
        private final Function<User, T> applicationFactory;
        private final List<LoadTest.Scenario<T>> scenarios = new ArrayList<LoadTest.Scenario<T>>();
        private final Consumer<T> closeApplication;
        private String name;
        private User user;
        private int minimumThinkTime = 2500;
        private int maximumThinkTime = 5000;
        private int loginDelayFactor = 2;
        private int applicationBatchSize = 10;

        DefaultBuilder(Function<User, T> applicationFactory, Consumer<T> closeApplication) {
            this.applicationFactory = Objects.requireNonNull(applicationFactory);
            this.closeApplication = Objects.requireNonNull(closeApplication);
        }

        @Override
        public LoadTest.Builder<T> user(User user) {
            this.user = Objects.requireNonNull(user);
            return this;
        }

        @Override
        public LoadTest.Builder<T> minimumThinkTime(int minimumThinkTime) {
            if (minimumThinkTime <= 0) {
                throw new IllegalArgumentException("Minimum think time must be a positive integer");
            }
            if (minimumThinkTime > this.maximumThinkTime) {
                throw new IllegalArgumentException("Minimum think time must be less than maximum think time");
            }
            this.minimumThinkTime = minimumThinkTime;
            return this;
        }

        @Override
        public LoadTest.Builder<T> maximumThinkTime(int maximumThinkTime) {
            if (maximumThinkTime <= 0) {
                throw new IllegalArgumentException("Maximum think time must be a positive integer");
            }
            if (maximumThinkTime < this.minimumThinkTime) {
                throw new IllegalArgumentException("Maximum think time must be greater than than minimum think time");
            }
            this.maximumThinkTime = maximumThinkTime;
            return this;
        }

        @Override
        public LoadTest.Builder<T> loginDelayFactor(int loginDelayFactor) {
            if (loginDelayFactor < 1) {
                throw new IllegalArgumentException("Login delay factor must be greatar than or equal to one");
            }
            this.loginDelayFactor = loginDelayFactor;
            return this;
        }

        @Override
        public LoadTest.Builder<T> applicationBatchSize(int applicationBatchSize) {
            if (this.loginDelayFactor < 1) {
                throw new IllegalArgumentException("Application batch size must be greatar than or equal to one");
            }
            this.applicationBatchSize = applicationBatchSize;
            return this;
        }

        @Override
        public LoadTest.Builder<T> scenarios(Collection<? extends LoadTest.Scenario<T>> scenarios) {
            this.scenarios.addAll(Objects.requireNonNull(scenarios));
            return this;
        }

        @Override
        public LoadTest.Builder<T> name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @Override
        public LoadTest<T> build() {
            return new DefaultLoadTest(this);
        }
    }

    private static class MinimumValidator
    implements Value.Validator<Integer> {
        private final int minimumValue;

        private MinimumValidator(int minimumValue) {
            this.minimumValue = minimumValue;
        }

        public void validate(Integer value) {
            if (value == null || value < this.minimumValue) {
                throw new IllegalArgumentException("Value must be larger than: " + this.minimumValue);
            }
        }
    }

    private final class MinimumThinkTimeValidator
    extends MinimumValidator {
        private MinimumThinkTimeValidator() {
            super(0);
        }

        @Override
        public void validate(Integer value) {
            super.validate(value);
            if (value > (Integer)DefaultLoadTest.this.maximumThinkTime.get()) {
                throw new IllegalArgumentException("Minimum think time must be equal to or below maximum think time");
            }
        }
    }

    private final class MaximumThinkTimeValidator
    extends MinimumValidator {
        private MaximumThinkTimeValidator() {
            super(0);
        }

        @Override
        public void validate(Integer value) {
            super.validate(value);
            if (value < (Integer)DefaultLoadTest.this.minimumThinkTime.get()) {
                throw new IllegalArgumentException("Maximum think time must be equal to or exceed minimum think time");
            }
        }
    }

    private final class DefaultApplicationRunner
    implements LoadTest.ApplicationRunner {
        private static final int MAX_RESULTS = 20;
        private final User user;
        private final Function<User, T> applicationFactory;
        private final List<LoadTest.Scenario.Result> results = new ArrayList<LoadTest.Scenario.Result>();
        private final AtomicBoolean stopped = new AtomicBoolean();
        private final LocalDateTime created = LocalDateTime.now();
        private T application;

        private DefaultApplicationRunner(User user, Function<User, T> applicationFactory) {
            this.user = user;
            this.applicationFactory = applicationFactory;
        }

        @Override
        public String name() {
            return this.application == null ? "Not initialized" : this.application.toString();
        }

        @Override
        public User user() {
            return this.user;
        }

        @Override
        public LocalDateTime created() {
            return this.created;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<LoadTest.Scenario.Result> results() {
            List<LoadTest.Scenario.Result> list = this.results;
            synchronized (list) {
                return Collections.unmodifiableList(new ArrayList<LoadTest.Scenario.Result>(this.results));
            }
        }

        @Override
        public boolean stopped() {
            return this.stopped.get();
        }

        @Override
        public void stop() {
            this.stopped.set(true);
        }

        @Override
        public void run() {
            if (this.stopped.get()) {
                this.cleanupOnStop();
                return;
            }
            try {
                if (!((Boolean)DefaultLoadTest.this.paused.get()).booleanValue()) {
                    if (this.application == null && !this.stopped.get()) {
                        this.application = this.initializeApplication();
                    } else if (!this.stopped.get()) {
                        this.runScenario(this.application, DefaultLoadTest.this.scenarioChooser.randomItem());
                    }
                }
                if (this.stopped.get()) {
                    this.cleanupOnStop();
                    return;
                }
                DefaultLoadTest.this.scheduledExecutor.schedule(this, (long)this.thinkTime(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.debug("Exception during run {}", this.application, (Object)e);
            }
        }

        private void cleanupOnStop() {
            if (this.application != null) {
                DefaultLoadTest.this.closeApplication.accept(this.application);
                LOG.debug("LoadTestModel disconnected application: {}", this.application);
                this.application = null;
            }
        }

        private T initializeApplication() {
            try {
                long startTime = System.nanoTime();
                Object app = this.applicationFactory.apply(this.user);
                int duration = (int)TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime);
                this.addResult(LoadTest.Scenario.Result.success("Initialization", duration));
                LOG.debug("LoadTestModel initialized application: {}", app);
                return app;
            }
            catch (Exception e) {
                this.addResult(LoadTest.Scenario.Result.failure("Initialization", e));
                return null;
            }
        }

        private void runScenario(T application, LoadTest.Scenario<T> scenario) {
            LoadTest.Scenario.Result result = scenario.run(application);
            this.addResult(result);
            DefaultLoadTest.this.resultEvent.accept((Object)result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addResult(LoadTest.Scenario.Result result) {
            List<LoadTest.Scenario.Result> list = this.results;
            synchronized (list) {
                this.results.add(result);
                if (this.results.size() > 20) {
                    this.results.remove(0);
                }
            }
        }

        private int thinkTime() {
            int time = (Integer)DefaultLoadTest.this.maximumThinkTime.get() - (Integer)DefaultLoadTest.this.minimumThinkTime.get();
            return time > 0 ? RANDOM.nextInt(time) + (Integer)DefaultLoadTest.this.minimumThinkTime.get() : (Integer)DefaultLoadTest.this.minimumThinkTime.get();
        }
    }
}

