/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.randomizer;

import is.codion.common.model.randomizer.ItemRandomizer;

final class DefaultRandomItem<T>
implements ItemRandomizer.RandomItem<T> {
    private static final String WEIGHT_CAN_NOT_BE_NEGATIVE = "Weight can not be negative";
    private final T item;
    private int weight;
    private boolean enabled = true;

    DefaultRandomItem(T item, int weight) {
        if (weight < 0) {
            throw new IllegalArgumentException(WEIGHT_CAN_NOT_BE_NEGATIVE);
        }
        this.item = item;
        this.weight = weight;
    }

    @Override
    public int weight() {
        return this.enabled ? this.weight : 0;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public T item() {
        return this.item;
    }

    public String toString() {
        return this.item.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof ItemRandomizer.RandomItem && ((ItemRandomizer.RandomItem)obj).item().equals(this.item);
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    @Override
    public void incrementWeight() {
        ++this.weight;
    }

    @Override
    public void decrementWeight() {
        if (this.weight == 0) {
            throw new IllegalStateException(WEIGHT_CAN_NOT_BE_NEGATIVE);
        }
        --this.weight;
    }

    @Override
    public void setWeight(int weight) {
        if (weight < 0) {
            throw new IllegalArgumentException(WEIGHT_CAN_NOT_BE_NEGATIVE);
        }
        this.weight = weight;
    }
}

