/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.table;

import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.model.table.TableSummaryModel;
import java.text.Format;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class DefaultTableSummaryModel<C>
implements TableSummaryModel<C> {
    private final ColumnSummaryModel.SummaryValues.Factory<C> summaryValuesFactory;
    private final Map<C, ColumnSummaryModel> columnSummaryModels = new HashMap<C, ColumnSummaryModel>();

    DefaultTableSummaryModel(ColumnSummaryModel.SummaryValues.Factory<C> summaryValuesFactory) {
        this.summaryValuesFactory = Objects.requireNonNull(summaryValuesFactory);
    }

    @Override
    public Optional<ColumnSummaryModel> summaryModel(C columnIdentifier) {
        return Optional.ofNullable(this.columnSummaryModels.computeIfAbsent(columnIdentifier, k -> this.createSummaryModel(k, NumberFormat.getInstance()).orElse(null)));
    }

    private Optional<ColumnSummaryModel> createSummaryModel(C columnIdentifier, Format format) {
        return this.summaryValuesFactory.createSummaryValues(columnIdentifier, format).map(ColumnSummaryModel::columnSummaryModel);
    }
}

