/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.table;

import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.resource.MessageBundle;
import java.util.Collection;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.ResourceBundle;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ColumnSummary implements ColumnSummaryModel.Summary
{
    NONE{

        public String toString() {
            return MESSAGES.getString("none");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValues<T> summaryValues) {
            return "";
        }
    }
    ,
    SUM{

        public String toString() {
            return MESSAGES.getString("sum");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValues<T> summaryValues) {
            Collection<T> values = summaryValues.values();
            if (!values.isEmpty()) {
                return ColumnSummary.addSubsetIndicator(summaryValues.format(values.stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).sum()), summaryValues.subset());
            }
            return "";
        }
    }
    ,
    AVERAGE{

        public String toString() {
            return MESSAGES.getString("average");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValues<T> summaryValues) {
            OptionalDouble average;
            Collection<T> values = summaryValues.values();
            if (!values.isEmpty() && (average = values.stream().mapToDouble(value -> value == null ? 0.0 : value.doubleValue()).average()).isPresent()) {
                return ColumnSummary.addSubsetIndicator(summaryValues.format(average.getAsDouble()), summaryValues.subset());
            }
            return "";
        }
    }
    ,
    MINIMUM{

        public String toString() {
            return MESSAGES.getString("minimum");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValues<T> summaryValues) {
            OptionalDouble min;
            Collection<T> values = summaryValues.values();
            if (!values.isEmpty() && (min = values.stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).min()).isPresent()) {
                return ColumnSummary.addSubsetIndicator(summaryValues.format(min.getAsDouble()), summaryValues.subset());
            }
            return "";
        }
    }
    ,
    MAXIMUM{

        public String toString() {
            return MESSAGES.getString("maximum");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValues<T> summaryValues) {
            OptionalDouble max;
            Collection<T> values = summaryValues.values();
            if (!values.isEmpty() && (max = values.stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).max()).isPresent()) {
                return ColumnSummary.addSubsetIndicator(summaryValues.format(max.getAsDouble()), summaryValues.subset());
            }
            return "";
        }
    }
    ,
    MINIMUM_MAXIMUM{

        public String toString() {
            return MESSAGES.getString("minimum_and_maximum");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValues<T> summaryValues) {
            Collection<T> values = summaryValues.values();
            if (!values.isEmpty()) {
                OptionalDouble min = values.stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).min();
                OptionalDouble max = values.stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).max();
                if (min.isPresent() && max.isPresent()) {
                    return ColumnSummary.addSubsetIndicator(summaryValues.format(min.getAsDouble()) + "/" + summaryValues.format(max.getAsDouble()), summaryValues.subset());
                }
            }
            return "";
        }
    };

    private static final MessageBundle MESSAGES;

    private static String addSubsetIndicator(String text, boolean subset) {
        return text.isEmpty() ? text : text + (subset ? "*" : "");
    }

    static {
        MESSAGES = MessageBundle.messageBundle(ColumnSummary.class, (ResourceBundle)ResourceBundle.getBundle(ColumnSummary.class.getName()));
    }
}

