/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.table;

import is.codion.common.model.table.ColumnSummary;
import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class DefaultColumnSummaryModel<T extends Number>
implements ColumnSummaryModel {
    private final Value<? extends ColumnSummaryModel.Summary> summary = Value.nonNull((Object)ColumnSummary.NONE).listener(this::updateSummary).build();
    private final Value<String> summaryText = Value.value();
    private final State locked = State.state();
    private final ColumnSummaryModel.SummaryValueProvider<T> valueProvider;
    private final List<ColumnSummaryModel.Summary> summaries = Arrays.asList(ColumnSummary.values());

    DefaultColumnSummaryModel(ColumnSummaryModel.SummaryValueProvider<T> valueProvider) {
        this.valueProvider = Objects.requireNonNull(valueProvider);
        this.summary.addValidator(summary -> {
            if (((Boolean)this.locked.get()).booleanValue()) {
                throw new IllegalStateException("Summary model is locked");
            }
        });
        this.valueProvider.changeEvent().addListener(this::updateSummary);
    }

    @Override
    public State locked() {
        return this.locked;
    }

    @Override
    public Value<ColumnSummaryModel.Summary> summary() {
        return this.summary;
    }

    @Override
    public List<ColumnSummaryModel.Summary> summaries() {
        return this.summaries;
    }

    @Override
    public ValueObserver<String> summaryText() {
        return this.summaryText.observer();
    }

    private void updateSummary() {
        this.summaryText.set((Object)((ColumnSummaryModel.Summary)this.summary().get()).summary(this.valueProvider));
    }

    static final class DefaultSummaryValues<T extends Number>
    implements ColumnSummaryModel.SummaryValues<T> {
        private final Collection<T> values;
        private final boolean subset;

        DefaultSummaryValues(Collection<T> values, boolean subset) {
            this.values = Objects.requireNonNull(values, "values");
            this.subset = subset;
        }

        @Override
        public Collection<T> values() {
            return this.values;
        }

        @Override
        public boolean subset() {
            return this.subset;
        }
    }
}

