/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.table;

import is.codion.common.Configuration;
import is.codion.common.Operator;
import is.codion.common.event.EventObserver;
import is.codion.common.model.table.DefaultColumnConditionModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import java.text.Format;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;

public interface ColumnConditionModel<C, T> {
    public static final PropertyValue<AutomaticWildcard> AUTOMATIC_WILDCARD = Configuration.enumValue((String)"is.codion.common.model.table.ColumnConditionModel.automaticWildard", AutomaticWildcard.class, (Enum)AutomaticWildcard.POSTFIX);
    public static final PropertyValue<Boolean> CASE_SENSITIVE = Configuration.booleanValue((String)"is.codion.common.model.table.ColumnConditionModel.caseSensitive", (boolean)false);

    public C columnIdentifier();

    public State caseSensitive();

    public Format format();

    public String dateTimePattern();

    public Value<AutomaticWildcard> automaticWildcard();

    public State autoEnable();

    public State locked();

    public Class<T> columnClass();

    public void setEqualValue(T var1);

    public T getEqualValue();

    public void setEqualValues(Collection<T> var1);

    public Collection<T> getEqualValues();

    public void setUpperBound(T var1);

    public T getUpperBound();

    public void setLowerBound(T var1);

    public T getLowerBound();

    public List<Operator> operators();

    public char wildcard();

    public State enabled();

    public void clear();

    public ValueSet<T> equalValues();

    public Value<T> upperBoundValue();

    public Value<T> lowerBoundValue();

    public Value<Operator> operator();

    public boolean accepts(Comparable<T> var1);

    public EventObserver<?> conditionChangedEvent();

    public static <C, T> Builder<C, T> builder(C columnIdentifier, Class<T> columnClass) {
        return new DefaultColumnConditionModel.DefaultBuilder<C, T>(columnIdentifier, columnClass);
    }

    public static String caption(Operator operator) {
        switch (Objects.requireNonNull(operator)) {
            case EQUAL: {
                return "\u03b1 =";
            }
            case NOT_EQUAL: {
                return "\u03b1 \u2260";
            }
            case LESS_THAN: {
                return "\u03b1 <";
            }
            case LESS_THAN_OR_EQUAL: {
                return "\u03b1 \u2264";
            }
            case GREATER_THAN: {
                return "\u03b1 >";
            }
            case GREATER_THAN_OR_EQUAL: {
                return "\u03b1 \u2265";
            }
            case BETWEEN_EXCLUSIVE: {
                return "< \u03b1 <";
            }
            case BETWEEN: {
                return "\u2264 \u03b1 \u2264";
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return "\u2265 \u03b1 \u2265";
            }
            case NOT_BETWEEN: {
                return "> \u03b1 >";
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + operator);
    }

    public static enum AutomaticWildcard {
        NONE,
        PREFIX,
        POSTFIX,
        PREFIX_AND_POSTFIX;

        private final String description = ResourceBundle.getBundle(AutomaticWildcard.class.getName()).getString(this.toString());

        public String description() {
            return this.description;
        }
    }

    public static interface Builder<C, T> {
        public Builder<C, T> operators(List<Operator> var1);

        public Builder<C, T> wildcard(char var1);

        public Builder<C, T> format(Format var1);

        public Builder<C, T> dateTimePattern(String var1);

        public Builder<C, T> automaticWildcard(AutomaticWildcard var1);

        public Builder<C, T> caseSensitive(boolean var1);

        public Builder<C, T> autoEnable(boolean var1);

        public ColumnConditionModel<C, T> build();
    }

    public static interface Factory<C> {
        public Optional<ColumnConditionModel<? extends C, ?>> createConditionModel(C var1);
    }
}

