/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.loadtest;

import is.codion.common.event.EventObserver;
import is.codion.common.model.loadtest.DefaultLoadTest;
import is.codion.common.model.loadtest.DefaultScenario;
import is.codion.common.model.randomizer.ItemRandomizer;
import is.codion.common.state.State;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public interface LoadTest<T> {
    public static final int DEFAULT_MINIMUM_THINKTIME = 2500;
    public static final int DEFAULT_MAXIMUM_THINKTIME = 5000;
    public static final int DEFAULT_LOGIN_DELAY_FACTOR = 2;
    public static final int DEFAULT_APPLICATION_BATCH_SIZE = 10;

    public void shutdown();

    public void stop(ApplicationRunner var1);

    public Value<User> user();

    public Optional<String> name();

    public void setWeight(String var1, int var2);

    public boolean isScenarioEnabled(String var1);

    public void setScenarioEnabled(String var1, boolean var2);

    public Collection<Scenario<T>> scenarios();

    public Scenario<T> scenario(String var1);

    public EventObserver<Scenario.Result> resultEvent();

    public void addShutdownListener(Runnable var1);

    public Value<Integer> applicationBatchSize();

    public State paused();

    public Value<Integer> maximumThinkTime();

    public Value<Integer> minimumThinkTime();

    public Value<Integer> loginDelayFactor();

    public Map<ApplicationRunner, T> applications();

    public ValueObserver<Integer> applicationCount();

    public void addApplicationBatch();

    public void removeApplicationBatch();

    public ItemRandomizer<Scenario<T>> scenarioChooser();

    public static <T> Builder<T> builder(Function<User, T> applicationFactory, Consumer<T> closeApplication) {
        return new DefaultLoadTest.DefaultBuilder<T>(applicationFactory, closeApplication);
    }

    public static interface Scenario<T> {
        public String name();

        public int defaultWeight();

        public Result run(T var1);

        public static <T> Builder<T> builder(Performer<T> performer) {
            return new DefaultScenario.DefaultBuilder<T>(performer);
        }

        public static <T> Scenario<T> scenario(Performer<T> performer) {
            return Scenario.builder(performer).build();
        }

        public static <T> Scenario<T> scenario(Performer<T> performer, int defaultWeight) {
            return Scenario.builder(performer).defaultWeight(defaultWeight).build();
        }

        public static interface Performer<T> {
            public void perform(T var1) throws Exception;
        }

        public static interface Builder<T> {
            public Builder<T> name(String var1);

            public Builder<T> defaultWeight(int var1);

            public Builder<T> beforeRun(Consumer<T> var1);

            public Builder<T> afterRun(Consumer<T> var1);

            public Scenario<T> build();
        }

        public static interface Result {
            public String scenario();

            public int duration();

            public boolean successful();

            public Optional<Throwable> exception();

            public static Result success(String scenarioName, int duration) {
                return new DefaultScenario.DefaultRunResult(scenarioName, duration, null);
            }

            public static Result failure(String scenarioName, Throwable exception) {
                return new DefaultScenario.DefaultRunResult(scenarioName, -1, exception);
            }
        }
    }

    public static interface ApplicationRunner
    extends Runnable {
        public String name();

        public User user();

        public LocalDateTime created();

        public List<Scenario.Result> results();

        public boolean stopped();

        public void stop();
    }

    public static interface Builder<T> {
        public Builder<T> user(User var1);

        public Builder<T> minimumThinkTime(int var1);

        public Builder<T> maximumThinkTime(int var1);

        public Builder<T> loginDelayFactor(int var1);

        public Builder<T> applicationBatchSize(int var1);

        public Builder<T> scenarios(Collection<? extends Scenario<T>> var1);

        public Builder<T> name(String var1);

        public LoadTest<T> build();
    }
}

