/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model;

import is.codion.common.Configuration;
import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface FilteredModel<T> {
    public static final PropertyValue<Boolean> ASYNC_REFRESH = Configuration.booleanValue((String)"is.codion.common.model.FilteredModel.asyncRefresh", (boolean)true);

    public void filterItems();

    public Value<Predicate<T>> includeCondition();

    public Collection<T> items();

    public List<T> visibleItems();

    public Collection<T> filteredItems();

    public int visibleCount();

    public int filteredCount();

    public boolean containsItem(T var1);

    public boolean visible(T var1);

    public boolean filtered(T var1);

    public Refresher<T> refresher();

    public void refresh();

    public void refreshThen(Consumer<Collection<T>> var1);

    public static abstract class AbstractRefresher<T>
    implements Refresher<T> {
        private final Event<?> refreshEvent = Event.event();
        private final Event<Throwable> refreshFailedEvent = Event.event();
        private final State refreshingState = State.state();
        private final Value<Supplier<Collection<T>>> itemSupplier;
        private final State async = State.state((boolean)((Boolean)ASYNC_REFRESH.get()));

        protected AbstractRefresher(Supplier<Collection<T>> itemSupplier) {
            this.itemSupplier = Value.value(Objects.requireNonNull(itemSupplier), itemSupplier);
        }

        @Override
        public final State async() {
            return this.async;
        }

        @Override
        public final Value<Supplier<Collection<T>>> itemSupplier() {
            return this.itemSupplier;
        }

        @Override
        public final void refresh() {
            this.refreshThen(null);
        }

        @Override
        public final void refreshThen(Consumer<Collection<T>> afterRefresh) {
            if (((Boolean)this.async.get()).booleanValue() && this.supportsAsyncRefresh()) {
                this.refreshAsync(afterRefresh);
            } else {
                this.refreshSync(afterRefresh);
            }
        }

        @Override
        public final StateObserver observer() {
            return this.refreshingState.observer();
        }

        @Override
        public final EventObserver<?> refreshEvent() {
            return this.refreshEvent.observer();
        }

        @Override
        public EventObserver<Throwable> refreshFailedEvent() {
            return this.refreshFailedEvent.observer();
        }

        protected final void setRefreshing(boolean refreshing) {
            this.refreshingState.set((Object)refreshing);
        }

        protected final void notifySuccess() {
            this.refreshEvent.run();
        }

        protected final void notifyFailure(Throwable throwable) {
            this.refreshFailedEvent.accept((Object)throwable);
        }

        protected abstract boolean supportsAsyncRefresh();

        protected abstract void refreshAsync(Consumer<Collection<T>> var1);

        protected abstract void refreshSync(Consumer<Collection<T>> var1);

        protected abstract void processResult(Collection<T> var1);
    }

    public static interface Refresher<T> {
        public State async();

        public Value<Supplier<Collection<T>>> itemSupplier();

        public void refresh();

        public void refreshThen(Consumer<Collection<T>> var1);

        public StateObserver observer();

        public EventObserver<?> refreshEvent();

        public EventObserver<Throwable> refreshFailedEvent();
    }
}

