/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.loadtest;

import is.codion.common.model.loadtest.LoadTest;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

final class DefaultScenario<T>
implements LoadTest.Scenario<T> {
    private static final Consumer<?> EMPTY_CONSUMER = object -> {};
    private final String name;
    private final int defaultWeight;
    private final LoadTest.Scenario.Performer<T> performer;
    private final Consumer<T> beforeRun;
    private final Consumer<T> afterRun;

    private DefaultScenario(DefaultBuilder<T> builder) {
        this.performer = builder.performer;
        this.name = builder.name;
        this.defaultWeight = builder.defaultWeight;
        this.beforeRun = builder.beforeRun;
        this.afterRun = builder.afterRun;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int defaultWeight() {
        return this.defaultWeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoadTest.Scenario.Result run(T application) {
        Objects.requireNonNull(application, "Can not run without an application");
        try {
            this.beforeRun.accept(application);
            long startTime = System.nanoTime();
            this.performer.perform(application);
            LoadTest.Scenario.Result result = LoadTest.Scenario.Result.success(this.name, (int)TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime));
            return result;
        }
        catch (Throwable e) {
            LoadTest.Scenario.Result result = LoadTest.Scenario.Result.failure(this.name, e);
            return result;
        }
        finally {
            this.afterRun.accept(application);
        }
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof LoadTest.Scenario && ((LoadTest.Scenario)obj).name().equals(this.name);
    }

    static final class DefaultBuilder<T>
    implements LoadTest.Scenario.Builder<T> {
        private final LoadTest.Scenario.Performer<T> performer;
        private String name;
        private int defaultWeight = 1;
        private Consumer<T> beforeRun = EMPTY_CONSUMER;
        private Consumer<T> afterRun = EMPTY_CONSUMER;

        DefaultBuilder(LoadTest.Scenario.Performer<T> performer) {
            this.performer = Objects.requireNonNull(performer);
            this.name = performer.getClass().getSimpleName();
        }

        @Override
        public LoadTest.Scenario.Builder<T> name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @Override
        public LoadTest.Scenario.Builder<T> defaultWeight(int defaultWeight) {
            if (defaultWeight < 0) {
                throw new IllegalArgumentException("Default weight must be a positive integer");
            }
            this.defaultWeight = defaultWeight;
            return this;
        }

        @Override
        public LoadTest.Scenario.Builder<T> beforeRun(Consumer<T> beforeRun) {
            this.beforeRun = Objects.requireNonNull(beforeRun);
            return this;
        }

        @Override
        public LoadTest.Scenario.Builder<T> afterRun(Consumer<T> afterRun) {
            this.afterRun = Objects.requireNonNull(afterRun);
            return this;
        }

        @Override
        public LoadTest.Scenario<T> build() {
            return new DefaultScenario(this);
        }
    }

    static final class DefaultRunResult
    implements LoadTest.Scenario.Result {
        private final String scenario;
        private final int duration;
        private final Throwable exception;

        DefaultRunResult(String scenario, int duration, Throwable exception) {
            this.scenario = Objects.requireNonNull(scenario);
            this.duration = duration;
            this.exception = exception;
        }

        @Override
        public int duration() {
            return this.duration;
        }

        @Override
        public String scenario() {
            return this.scenario;
        }

        @Override
        public boolean successful() {
            return this.exception == null;
        }

        @Override
        public Optional<Throwable> exception() {
            return Optional.ofNullable(this.exception);
        }
    }
}

