/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.table;

import is.codion.common.model.table.ColumnSummaryModel;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.ResourceBundle;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ColumnSummary implements ColumnSummaryModel.Summary
{
    NONE{

        public String toString() {
            return MESSAGES.getString("none");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValueProvider<T> valueProvider) {
            return "";
        }
    }
    ,
    SUM{

        public String toString() {
            return MESSAGES.getString("sum");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValueProvider<T> valueProvider) {
            ColumnSummaryModel.SummaryValues<T> summaryValues = valueProvider.values();
            if (!summaryValues.values().isEmpty()) {
                return ColumnSummary.addSubsetIndicator(valueProvider.format(summaryValues.values().stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).sum()), summaryValues.subset());
            }
            return "";
        }
    }
    ,
    AVERAGE{

        public String toString() {
            return MESSAGES.getString("average");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValueProvider<T> valueProvider) {
            OptionalDouble average;
            ColumnSummaryModel.SummaryValues<T> summaryValues = valueProvider.values();
            if (!summaryValues.values().isEmpty() && (average = summaryValues.values().stream().mapToDouble(value -> value == null ? 0.0 : value.doubleValue()).average()).isPresent()) {
                return ColumnSummary.addSubsetIndicator(valueProvider.format(average.getAsDouble()), summaryValues.subset());
            }
            return "";
        }
    }
    ,
    MINIMUM{

        public String toString() {
            return MESSAGES.getString("minimum");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValueProvider<T> valueProvider) {
            OptionalDouble min;
            ColumnSummaryModel.SummaryValues<T> summaryValues = valueProvider.values();
            if (!summaryValues.values().isEmpty() && (min = summaryValues.values().stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).min()).isPresent()) {
                return ColumnSummary.addSubsetIndicator(valueProvider.format(min.getAsDouble()), summaryValues.subset());
            }
            return "";
        }
    }
    ,
    MAXIMUM{

        public String toString() {
            return MESSAGES.getString("maximum");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValueProvider<T> valueProvider) {
            OptionalDouble max;
            ColumnSummaryModel.SummaryValues<T> summaryValues = valueProvider.values();
            if (!summaryValues.values().isEmpty() && (max = summaryValues.values().stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).max()).isPresent()) {
                return ColumnSummary.addSubsetIndicator(valueProvider.format(max.getAsDouble()), summaryValues.subset());
            }
            return "";
        }
    }
    ,
    MINIMUM_MAXIMUM{

        public String toString() {
            return MESSAGES.getString("minimum_and_maximum");
        }

        @Override
        public <T extends Number> String summary(ColumnSummaryModel.SummaryValueProvider<T> valueProvider) {
            ColumnSummaryModel.SummaryValues<T> summaryValues = valueProvider.values();
            if (!summaryValues.values().isEmpty()) {
                OptionalDouble min = summaryValues.values().stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).min();
                OptionalDouble max = summaryValues.values().stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).max();
                if (min.isPresent() && max.isPresent()) {
                    return ColumnSummary.addSubsetIndicator(valueProvider.format(min.getAsDouble()) + "/" + valueProvider.format(max.getAsDouble()), summaryValues.subset());
                }
            }
            return "";
        }
    };

    private static final ResourceBundle MESSAGES;

    private static String addSubsetIndicator(String text, boolean subset) {
        return text.isEmpty() ? text : text + (subset ? "*" : "");
    }

    static {
        MESSAGES = ResourceBundle.getBundle(ColumnSummary.class.getName());
    }
}

