/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.table;

import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableConditionModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DefaultTableConditionModel<C>
implements TableConditionModel<C> {
    private final Map<C, ColumnConditionModel<C, ?>> conditionModels;

    DefaultTableConditionModel(Collection<ColumnConditionModel<C, ?>> conditionModels) {
        this.conditionModels = this.initializeColumnConditionModels(conditionModels);
    }

    @Override
    public void clear() {
        this.conditionModels.values().forEach(ColumnConditionModel::clear);
    }

    @Override
    public boolean enabled() {
        return this.conditionModels.values().stream().anyMatch(model -> (Boolean)model.enabled().get());
    }

    @Override
    public boolean enabled(C columnIdentifier) {
        return this.conditionModels.containsKey(columnIdentifier) && (Boolean)this.conditionModels.get(columnIdentifier).enabled().get() != false;
    }

    @Override
    public Map<C, ColumnConditionModel<C, ?>> conditionModels() {
        return this.conditionModels;
    }

    @Override
    public <T> ColumnConditionModel<C, T> conditionModel(C columnIdentifier) {
        ColumnConditionModel<C, ?> conditionModel = this.conditionModels.get(columnIdentifier);
        if (conditionModel == null) {
            throw new IllegalArgumentException("No condition model available for column: " + columnIdentifier);
        }
        return conditionModel;
    }

    @Override
    public void addChangeListener(Runnable listener) {
        this.conditionModels.values().forEach(filterModel -> filterModel.addChangeListener(listener));
    }

    @Override
    public void removeChangeListener(Runnable listener) {
        this.conditionModels.values().forEach(filterModel -> filterModel.removeChangeListener(listener));
    }

    private Map<C, ColumnConditionModel<C, ?>> initializeColumnConditionModels(Collection<ColumnConditionModel<C, ?>> conditionModels) {
        return Collections.unmodifiableMap(conditionModels.stream().collect(Collectors.toMap(ColumnConditionModel::columnIdentifier, Function.identity())));
    }
}

