/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.model.table;

import is.codion.common.Operator;
import is.codion.common.Text;
import is.codion.common.event.Event;
import is.codion.common.format.LocaleDateTimePattern;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import java.text.Format;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DefaultColumnConditionModel<C, T>
implements ColumnConditionModel<C, T> {
    private static final String REGEX_WILDCARD = ".*";
    private final ValueSet<T> equalValues = ValueSet.valueSet((Value.Notify)Value.Notify.WHEN_SET);
    private final Value<T> equalValue = this.equalValues.value();
    private final Value<T> upperBoundValue = Value.value((Value.Notify)Value.Notify.WHEN_SET);
    private final Value<T> lowerBoundValue = Value.value((Value.Notify)Value.Notify.WHEN_SET);
    private final Value<Operator> operator = Value.value((Object)Operator.EQUAL, (Object)Operator.EQUAL);
    private final Event<?> conditionChangedEvent = Event.event();
    private final State caseSensitive;
    private final Value<ColumnConditionModel.AutomaticWildcard> automaticWildcard;
    private final String wildcard;
    private final State autoEnable;
    private final State enabled = State.state();
    private final State locked = State.state();
    private final C columnIdentifier;
    private final Class<T> columnClass;
    private final Format format;
    private final String dateTimePattern;
    private final List<Operator> operators;

    private DefaultColumnConditionModel(DefaultBuilder<C, T> builder) {
        this.columnIdentifier = builder.columnIdentifier;
        this.operators = Collections.unmodifiableList(builder.operators);
        this.columnClass = builder.columnClass;
        this.wildcard = String.valueOf(builder.wildcard);
        this.format = builder.format;
        this.dateTimePattern = builder.dateTimePattern;
        this.automaticWildcard = Value.value((Object)((Object)builder.automaticWildcard), (Object)((Object)ColumnConditionModel.AutomaticWildcard.NONE));
        this.caseSensitive = State.state((boolean)builder.caseSensitive);
        this.autoEnable = State.state((boolean)builder.autoEnable);
        this.enabled.addValidator(value -> this.checkLock());
        this.equalValues.addValidator(value -> this.checkLock());
        this.upperBoundValue.addValidator(value -> this.checkLock());
        this.lowerBoundValue.addValidator(value -> this.checkLock());
        this.operator.addValidator(this::validateOperator);
        this.operator.addValidator(value -> this.checkLock());
        this.bindEvents();
    }

    @Override
    public C columnIdentifier() {
        return this.columnIdentifier;
    }

    @Override
    public State caseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public Format format() {
        return this.format;
    }

    @Override
    public String dateTimePattern() {
        return this.dateTimePattern;
    }

    @Override
    public State locked() {
        return this.locked;
    }

    @Override
    public Class<T> columnClass() {
        return this.columnClass;
    }

    @Override
    public void setEqualValue(T value) {
        this.equalValue.set(value);
    }

    @Override
    public T getEqualValue() {
        return (T)this.addAutomaticWildcard(this.equalValue.get());
    }

    @Override
    public void setEqualValues(Collection<T> values) {
        this.equalValues.set(Objects.requireNonNull(values));
    }

    @Override
    public Collection<T> getEqualValues() {
        return ((Set)this.equalValues.get()).stream().map(this::addAutomaticWildcard).collect(Collectors.toList());
    }

    @Override
    public void setUpperBound(T value) {
        this.upperBoundValue.set(value);
    }

    @Override
    public T getUpperBound() {
        return (T)this.upperBoundValue.get();
    }

    @Override
    public void setLowerBound(T value) {
        this.lowerBoundValue.set(value);
    }

    @Override
    public T getLowerBound() {
        return (T)this.lowerBoundValue.get();
    }

    @Override
    public Value<Operator> operator() {
        return this.operator;
    }

    @Override
    public List<Operator> operators() {
        return this.operators;
    }

    @Override
    public char wildcard() {
        return this.wildcard.charAt(0);
    }

    @Override
    public State enabled() {
        return this.enabled;
    }

    @Override
    public Value<ColumnConditionModel.AutomaticWildcard> automaticWildcard() {
        return this.automaticWildcard;
    }

    @Override
    public State autoEnable() {
        return this.autoEnable;
    }

    @Override
    public void clear() {
        this.enabled.set((Object)false);
        this.setEqualValues(Collections.emptyList());
        this.setUpperBound(null);
        this.setLowerBound(null);
        this.operator.set((Object)Operator.EQUAL);
    }

    @Override
    public boolean accepts(Comparable<T> columnValue) {
        return this.valueAccepted(columnValue);
    }

    @Override
    public ValueSet<T> equalValues() {
        return this.equalValues;
    }

    @Override
    public Value<T> lowerBoundValue() {
        return this.lowerBoundValue;
    }

    @Override
    public Value<T> upperBoundValue() {
        return this.upperBoundValue;
    }

    @Override
    public void addChangeListener(Runnable listener) {
        this.conditionChangedEvent.addListener(listener);
    }

    @Override
    public void removeChangeListener(Runnable listener) {
        this.conditionChangedEvent.removeListener(listener);
    }

    private boolean valueAccepted(Comparable<T> comparable) {
        if (!((Boolean)this.caseSensitive.get()).booleanValue()) {
            comparable = DefaultColumnConditionModel.stringOrCharacterToLowerCase(comparable);
        }
        switch ((Operator)this.operator.get()) {
            case EQUAL: {
                return this.isEqual(comparable);
            }
            case NOT_EQUAL: {
                return this.isNotEqual(comparable);
            }
            case LESS_THAN: {
                return this.isLessThan(comparable);
            }
            case LESS_THAN_OR_EQUAL: {
                return this.isLessThanOrEqual(comparable);
            }
            case GREATER_THAN: {
                return this.isGreaterThan(comparable);
            }
            case GREATER_THAN_OR_EQUAL: {
                return this.isGreaterThanOrEqual(comparable);
            }
            case BETWEEN_EXCLUSIVE: {
                return this.isBetweenExclusive(comparable);
            }
            case BETWEEN: {
                return this.isBetween(comparable);
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return this.isNotBetweenExclusive(comparable);
            }
            case NOT_BETWEEN: {
                return this.isNotBetween(comparable);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + this.operator.get());
    }

    private boolean isEqual(Comparable<T> comparable) {
        T equalValue = this.getEqualValue();
        if (!((Boolean)this.caseSensitive.get()).booleanValue()) {
            equalValue = DefaultColumnConditionModel.stringOrCharacterToLowerCase(equalValue);
        }
        if (comparable == null) {
            return equalValue == null;
        }
        if (equalValue == null) {
            return comparable == null;
        }
        if (comparable instanceof String && ((String)equalValue).contains(this.wildcard)) {
            return this.isEqualWildcard((String)((Object)comparable));
        }
        return comparable.compareTo(equalValue) == 0;
    }

    private boolean isNotEqual(Comparable<T> comparable) {
        T equalValue = this.getEqualValue();
        if (!((Boolean)this.caseSensitive.get()).booleanValue()) {
            equalValue = DefaultColumnConditionModel.stringOrCharacterToLowerCase(equalValue);
        }
        if (comparable == null) {
            return equalValue != null;
        }
        if (equalValue == null) {
            return comparable != null;
        }
        if (comparable instanceof String && ((String)equalValue).contains(this.wildcard)) {
            return !this.isEqualWildcard((String)((Object)comparable));
        }
        return comparable.compareTo(equalValue) != 0;
    }

    private boolean isEqualWildcard(String value) {
        String equalValue = (String)this.getEqualValue();
        if (equalValue == null) {
            equalValue = "";
        }
        if (equalValue.equals(this.wildcard)) {
            return true;
        }
        if (!((Boolean)this.caseSensitive.get()).booleanValue()) {
            equalValue = equalValue.toLowerCase();
        }
        if (!equalValue.contains(this.wildcard)) {
            return value.compareTo(equalValue) == 0;
        }
        return Pattern.matches(Stream.of(equalValue.split(this.wildcard)).map(Pattern::quote).collect(Collectors.joining(REGEX_WILDCARD, "", equalValue.endsWith(this.wildcard) ? REGEX_WILDCARD : "")), value);
    }

    private boolean isLessThan(Comparable<T> comparable) {
        T upperBound = this.getUpperBound();
        return upperBound == null || comparable != null && comparable.compareTo(upperBound) < 0;
    }

    private boolean isLessThanOrEqual(Comparable<T> comparable) {
        T upperBound = this.getUpperBound();
        return upperBound == null || comparable != null && comparable.compareTo(upperBound) <= 0;
    }

    private boolean isGreaterThan(Comparable<T> comparable) {
        T lowerBound = this.getLowerBound();
        return lowerBound == null || comparable != null && comparable.compareTo(lowerBound) > 0;
    }

    private boolean isGreaterThanOrEqual(Comparable<T> comparable) {
        T lowerBound = this.getLowerBound();
        return lowerBound == null || comparable != null && comparable.compareTo(lowerBound) >= 0;
    }

    private boolean isBetweenExclusive(Comparable<T> comparable) {
        T lowerBound = this.getLowerBound();
        T upperBound = this.getUpperBound();
        if (lowerBound == null && upperBound == null) {
            return true;
        }
        if (comparable == null) {
            return false;
        }
        if (lowerBound == null) {
            return comparable.compareTo(upperBound) < 0;
        }
        if (upperBound == null) {
            return comparable.compareTo(lowerBound) > 0;
        }
        int lowerCompareResult = comparable.compareTo(lowerBound);
        int upperCompareResult = comparable.compareTo(upperBound);
        return lowerCompareResult > 0 && upperCompareResult < 0;
    }

    private boolean isBetween(Comparable<T> comparable) {
        T lowerBound = this.getLowerBound();
        T upperBound = this.getUpperBound();
        if (lowerBound == null && upperBound == null) {
            return true;
        }
        if (comparable == null) {
            return false;
        }
        if (lowerBound == null) {
            return comparable.compareTo(upperBound) <= 0;
        }
        if (upperBound == null) {
            return comparable.compareTo(lowerBound) >= 0;
        }
        int lowerCompareResult = comparable.compareTo(lowerBound);
        int upperCompareResult = comparable.compareTo(upperBound);
        return lowerCompareResult >= 0 && upperCompareResult <= 0;
    }

    private boolean isNotBetweenExclusive(Comparable<T> comparable) {
        T lowerBound = this.getLowerBound();
        T upperBound = this.getUpperBound();
        if (lowerBound == null && upperBound == null) {
            return true;
        }
        if (comparable == null) {
            return false;
        }
        if (lowerBound == null) {
            return comparable.compareTo(upperBound) > 0;
        }
        if (upperBound == null) {
            return comparable.compareTo(lowerBound) < 0;
        }
        int lowerCompareResult = comparable.compareTo(lowerBound);
        int upperCompareResult = comparable.compareTo(upperBound);
        return lowerCompareResult < 0 || upperCompareResult > 0;
    }

    private boolean isNotBetween(Comparable<T> comparable) {
        T lowerBound = this.getLowerBound();
        T upperBound = this.getUpperBound();
        if (lowerBound == null && upperBound == null) {
            return true;
        }
        if (comparable == null) {
            return false;
        }
        if (lowerBound == null) {
            return comparable.compareTo(upperBound) >= 0;
        }
        if (upperBound == null) {
            return comparable.compareTo(lowerBound) <= 0;
        }
        int lowerCompareResult = comparable.compareTo(lowerBound);
        int upperCompareResult = comparable.compareTo(upperBound);
        return lowerCompareResult <= 0 || upperCompareResult >= 0;
    }

    private T addAutomaticWildcard(T bound) {
        if (!(bound instanceof String)) {
            return bound;
        }
        switch ((Operator)this.operator.get()) {
            case EQUAL: 
            case NOT_EQUAL: {
                return (T)this.addAutomaticWildcard((String)bound);
            }
        }
        return bound;
    }

    private String addAutomaticWildcard(String value) {
        switch ((ColumnConditionModel.AutomaticWildcard)((Object)this.automaticWildcard.get())) {
            case PREFIX: {
                value = this.addWildcardPrefix(value);
                break;
            }
            case POSTFIX: {
                value = this.addWildcardPostfix(value);
                break;
            }
            case PREFIX_AND_POSTFIX: {
                value = this.addWildcardPrefix(value);
                value = this.addWildcardPostfix(value);
                break;
            }
        }
        return value;
    }

    private String addWildcardPrefix(String value) {
        if (!value.startsWith(this.wildcard)) {
            return this.wildcard + value;
        }
        return value;
    }

    private String addWildcardPostfix(String value) {
        if (!value.endsWith(this.wildcard)) {
            return value + this.wildcard;
        }
        return value;
    }

    private void bindEvents() {
        AutoEnableListener autoEnableListener = new AutoEnableListener();
        this.equalValues.addListener((Runnable)autoEnableListener);
        this.upperBoundValue.addListener((Runnable)autoEnableListener);
        this.lowerBoundValue.addListener((Runnable)autoEnableListener);
        this.operator.addListener((Runnable)autoEnableListener);
        this.autoEnable.addListener((Runnable)autoEnableListener);
        this.equalValues.addListener(this.conditionChangedEvent);
        this.upperBoundValue.addListener(this.conditionChangedEvent);
        this.lowerBoundValue.addListener(this.conditionChangedEvent);
        this.operator.addListener(this.conditionChangedEvent);
        this.enabled.addListener(this.conditionChangedEvent);
        this.caseSensitive.addListener(this.conditionChangedEvent);
        this.automaticWildcard.addListener(this.conditionChangedEvent);
    }

    private void checkLock() {
        if (((Boolean)this.locked.get()).booleanValue()) {
            throw new IllegalStateException("Condition model for column identified by " + this.columnIdentifier + " is locked");
        }
    }

    private void validateOperator(Operator operator) {
        if (!this.operators.contains(Objects.requireNonNull(operator, "operator"))) {
            throw new IllegalArgumentException("Operator " + operator + " not available in this condition model");
        }
    }

    private static <T> T stringOrCharacterToLowerCase(T value) {
        if (value instanceof String) {
            return (T)((String)value).toLowerCase();
        }
        if (value instanceof Character) {
            return (T)Character.valueOf(Character.toLowerCase(((Character)value).charValue()));
        }
        return value;
    }

    private static <T> Comparable<T> stringOrCharacterToLowerCase(Comparable<T> comparable) {
        if (comparable instanceof String) {
            return ((String)((Object)comparable)).toLowerCase();
        }
        if (comparable instanceof Character) {
            return Character.valueOf(Character.toLowerCase(((Character)comparable).charValue()));
        }
        return comparable;
    }

    static final class DefaultBuilder<C, T>
    implements ColumnConditionModel.Builder<C, T> {
        private final C columnIdentifier;
        private final Class<T> columnClass;
        private List<Operator> operators = Arrays.asList(Operator.values());
        private char wildcard = ((Character)Text.WILDCARD_CHARACTER.get()).charValue();
        private Format format;
        private String dateTimePattern = LocaleDateTimePattern.builder().delimiterDash().yearFourDigits().hoursMinutesSeconds().build().dateTimePattern();
        private ColumnConditionModel.AutomaticWildcard automaticWildcard = (ColumnConditionModel.AutomaticWildcard)((Object)ColumnConditionModel.AUTOMATIC_WILDCARD.get());
        private boolean caseSensitive = (Boolean)ColumnConditionModel.CASE_SENSITIVE.get();
        private boolean autoEnable = true;

        DefaultBuilder(C columnIdentifier, Class<T> columnClass) {
            this.columnIdentifier = Objects.requireNonNull(columnIdentifier);
            this.columnClass = Objects.requireNonNull(columnClass);
        }

        @Override
        public ColumnConditionModel.Builder<C, T> operators(List<Operator> operators) {
            if (Objects.requireNonNull(operators).isEmpty()) {
                throw new IllegalArgumentException("One or more operators must be specified");
            }
            this.operators = operators;
            return this;
        }

        @Override
        public ColumnConditionModel.Builder<C, T> wildcard(char wildcard) {
            this.wildcard = wildcard;
            return this;
        }

        @Override
        public ColumnConditionModel.Builder<C, T> format(Format format) {
            this.format = format;
            return this;
        }

        @Override
        public ColumnConditionModel.Builder<C, T> dateTimePattern(String dateTimePattern) {
            this.dateTimePattern = dateTimePattern;
            return this;
        }

        @Override
        public ColumnConditionModel.Builder<C, T> automaticWildcard(ColumnConditionModel.AutomaticWildcard automaticWildcard) {
            this.automaticWildcard = Objects.requireNonNull(automaticWildcard);
            return this;
        }

        @Override
        public ColumnConditionModel.Builder<C, T> caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public ColumnConditionModel.Builder<C, T> autoEnable(boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        @Override
        public ColumnConditionModel<C, T> build() {
            return new DefaultColumnConditionModel(this);
        }
    }

    private final class AutoEnableListener
    implements Runnable {
        private AutoEnableListener() {
        }

        @Override
        public void run() {
            if (((Boolean)DefaultColumnConditionModel.this.autoEnable.get()).booleanValue()) {
                switch ((Operator)DefaultColumnConditionModel.this.operator.get()) {
                    case EQUAL: 
                    case NOT_EQUAL: {
                        DefaultColumnConditionModel.this.enabled.set((Object)DefaultColumnConditionModel.this.equalValues.notEmpty());
                        break;
                    }
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        DefaultColumnConditionModel.this.enabled.set((Object)DefaultColumnConditionModel.this.upperBoundValue.isNotNull());
                        break;
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        DefaultColumnConditionModel.this.enabled.set((Object)DefaultColumnConditionModel.this.lowerBoundValue.isNotNull());
                        break;
                    }
                    case BETWEEN_EXCLUSIVE: 
                    case BETWEEN: 
                    case NOT_BETWEEN_EXCLUSIVE: 
                    case NOT_BETWEEN: {
                        DefaultColumnConditionModel.this.enabled.set((Object)(DefaultColumnConditionModel.this.lowerBoundValue.isNotNull() && DefaultColumnConditionModel.this.upperBoundValue.isNotNull() ? 1 : 0));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown operator: " + DefaultColumnConditionModel.this.operator.get());
                    }
                }
            }
        }
    }
}

