/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.pool;

import is.codion.common.db.pool.ConnectionPoolState;
import is.codion.common.db.pool.ConnectionPoolStatistics;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

final class DefaultConnectionPoolStatistics
implements ConnectionPoolStatistics,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String username;
    private long timestamp;
    private int connectionsInUse;
    private int availableInPool;
    private int connectionsCreated;
    private int connectionsDestroyed;
    private long creationDate;
    private List<ConnectionPoolState> snapshot = Collections.emptyList();
    private long resetDate;
    private int connectionRequests;
    private int requestsPerSecond;
    private int connectionRequestsFailed;
    private int requestsFailedPerSecond;
    private int averageCheckOutTime = 0;
    private int minimumCheckOutTime = 0;
    private int maximumCheckOutTime = 0;

    DefaultConnectionPoolStatistics(String username) {
        this.username = username;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public List<ConnectionPoolState> snapshot() {
        return this.snapshot;
    }

    @Override
    public int available() {
        return this.availableInPool;
    }

    @Override
    public int inUse() {
        return this.connectionsInUse;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public long creationDate() {
        return this.creationDate;
    }

    @Override
    public int created() {
        return this.connectionsCreated;
    }

    @Override
    public int destroyed() {
        return this.connectionsDestroyed;
    }

    @Override
    public int requests() {
        return this.connectionRequests;
    }

    @Override
    public int failedRequests() {
        return this.connectionRequestsFailed;
    }

    @Override
    public int failedRequestsPerSecond() {
        return this.requestsFailedPerSecond;
    }

    @Override
    public int requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Override
    public long averageGetTime() {
        return this.averageCheckOutTime;
    }

    @Override
    public long minimumCheckOutTime() {
        return this.minimumCheckOutTime;
    }

    @Override
    public long maximumCheckOutTime() {
        return this.maximumCheckOutTime;
    }

    @Override
    public int size() {
        return this.connectionsInUse + this.availableInPool;
    }

    @Override
    public long resetTime() {
        return this.resetDate;
    }

    void snapshot(List<ConnectionPoolState> snapshot) {
        this.snapshot = snapshot;
    }

    void availableInPool(int availableInPool) {
        this.availableInPool = availableInPool;
    }

    void connectionsInUse(int connectionsInUse) {
        this.connectionsInUse = connectionsInUse;
    }

    void timestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    void creationDate(long time) {
        this.creationDate = time;
    }

    void connectionsCreated(int connectionsCreated) {
        this.connectionsCreated = connectionsCreated;
    }

    void connectionsDestroyed(int connectionsDestroyed) {
        this.connectionsDestroyed = connectionsDestroyed;
    }

    void connectionRequests(int connectionRequests) {
        this.connectionRequests = connectionRequests;
    }

    void requestsPerSecond(int requestsPerSecond) {
        this.requestsPerSecond = requestsPerSecond;
    }

    void averageCheckOutTime(int averageCheckOutTime) {
        this.averageCheckOutTime = averageCheckOutTime;
    }

    void minimumCheckOutTime(int minimumCheckOutTime) {
        this.minimumCheckOutTime = minimumCheckOutTime;
    }

    void maximumCheckOutTime(int maximumCheckOutTime) {
        this.maximumCheckOutTime = maximumCheckOutTime;
    }

    void resetDate(long resetDate) {
        this.resetDate = resetDate;
    }

    void connectionRequestsFailed(int connectionRequestsFailed) {
        this.connectionRequestsFailed = connectionRequestsFailed;
    }

    void requestsFailedPerSecond(int requestsFailedPerSecond) {
        this.requestsFailedPerSecond = requestsFailedPerSecond;
    }
}

