/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.pool;

import is.codion.common.db.pool.AbstractConnectionPoolWrapper;
import is.codion.common.db.pool.ConnectionPoolStatistics;
import is.codion.common.db.pool.DefaultConnectionPoolState;
import is.codion.common.db.pool.DefaultConnectionPoolStatistics;
import is.codion.common.scheduler.TaskScheduler;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class DefaultConnectionPoolCounter {
    private static final double THOUSAND = 1000.0;
    private static final int SNAPSHOT_STATS_SIZE = 1000;
    private static final int SNAPSHOT_COLLECTION_INTERVAL_MS = 10;
    private static final int CHECK_OUT_TIMES_MAX_SIZE = 10000;
    private final AbstractConnectionPoolWrapper<?> connectionPool;
    private final long creationDate = System.currentTimeMillis();
    private final LinkedList<Integer> checkOutTimes = new LinkedList();
    private final LinkedList<DefaultConnectionPoolState> snapshotStatistics = new LinkedList();
    private volatile boolean collectSnapshotStatistics = false;
    private volatile boolean collectCheckOutTimes = false;
    private final TaskScheduler snapshotStatisticsCollector = TaskScheduler.builder((Runnable)new StatisticsCollector()).interval(10, TimeUnit.MILLISECONDS).build();
    private final AtomicLong resetDate = new AtomicLong(this.creationDate);
    private final AtomicLong requestsPerSecondTime = new AtomicLong(this.creationDate);
    private final AtomicInteger connectionsCreated = new AtomicInteger();
    private final AtomicInteger connectionsDestroyed = new AtomicInteger();
    private final AtomicInteger connectionRequests = new AtomicInteger();
    private final AtomicInteger requestsPerSecondCounter = new AtomicInteger();
    private final AtomicInteger connectionRequestsFailed = new AtomicInteger();
    private final AtomicInteger requestsFailedPerSecondCounter = new AtomicInteger();

    DefaultConnectionPoolCounter(AbstractConnectionPoolWrapper<?> connectionPool) {
        this.connectionPool = connectionPool;
    }

    boolean isCollectSnapshotStatistics() {
        return this.collectSnapshotStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCollectSnapshotStatistics(boolean collectSnapshotStatistics) {
        LinkedList<DefaultConnectionPoolState> linkedList = this.snapshotStatistics;
        synchronized (linkedList) {
            if (collectSnapshotStatistics) {
                IntStream.range(0, 1000).forEach(i -> this.snapshotStatistics.add(new DefaultConnectionPoolState()));
                this.snapshotStatisticsCollector.start();
            } else {
                this.snapshotStatisticsCollector.stop();
                this.snapshotStatistics.clear();
            }
            this.collectSnapshotStatistics = collectSnapshotStatistics;
        }
    }

    boolean isCollectCheckOutTimes() {
        return this.collectCheckOutTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCollectCheckOutTimes(boolean collectCheckOutTimes) {
        LinkedList<Integer> linkedList = this.checkOutTimes;
        synchronized (linkedList) {
            if (!collectCheckOutTimes) {
                this.checkOutTimes.clear();
            }
            this.collectCheckOutTimes = collectCheckOutTimes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCheckOutTime(int time) {
        if (this.collectCheckOutTimes) {
            LinkedList<Integer> linkedList = this.checkOutTimes;
            synchronized (linkedList) {
                this.checkOutTimes.add(time);
                if (this.checkOutTimes.size() > 10000) {
                    this.checkOutTimes.removeFirst();
                }
            }
        }
    }

    void incrementConnectionsDestroyedCounter() {
        this.connectionsDestroyed.incrementAndGet();
    }

    void incrementConnectionsCreatedCounter() {
        this.connectionsCreated.incrementAndGet();
    }

    void incrementFailedRequestCounter() {
        this.connectionRequestsFailed.incrementAndGet();
        this.requestsFailedPerSecondCounter.incrementAndGet();
    }

    void incrementRequestCounter() {
        this.connectionRequests.incrementAndGet();
        this.requestsPerSecondCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetStatistics() {
        this.connectionsCreated.set(0);
        this.connectionsDestroyed.set(0);
        this.connectionRequests.set(0);
        this.connectionRequestsFailed.set(0);
        LinkedList<Integer> linkedList = this.checkOutTimes;
        synchronized (linkedList) {
            this.checkOutTimes.clear();
        }
        this.resetDate.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionPoolStatistics collectStatistics(long since) {
        DefaultConnectionPoolStatistics statistics = new DefaultConnectionPoolStatistics(this.connectionPool.user().username());
        long current = System.currentTimeMillis();
        statistics.timestamp(current);
        statistics.resetDate(this.resetDate.get());
        statistics.availableInPool(this.connectionPool.available());
        statistics.connectionsInUse(this.connectionPool.inUse());
        statistics.connectionsCreated(this.connectionsCreated.get());
        statistics.connectionsDestroyed(this.connectionsDestroyed.get());
        statistics.creationDate(this.creationDate);
        statistics.connectionRequests(this.connectionRequests.get());
        statistics.connectionRequestsFailed(this.connectionRequestsFailed.get());
        double seconds = (double)(current - this.requestsPerSecondTime.get()) / 1000.0;
        this.requestsPerSecondTime.set(current);
        statistics.requestsPerSecond((int)((double)this.requestsPerSecondCounter.get() / seconds));
        this.requestsPerSecondCounter.set(0);
        statistics.requestsFailedPerSecond((int)((double)this.requestsFailedPerSecondCounter.get() / seconds));
        this.requestsFailedPerSecondCounter.set(0);
        if (!this.checkOutTimes.isEmpty()) {
            this.populateCheckOutTime(statistics);
        }
        if (this.collectSnapshotStatistics && since >= 0L) {
            LinkedList<DefaultConnectionPoolState> linkedList = this.snapshotStatistics;
            synchronized (linkedList) {
                statistics.snapshot(this.snapshotStatistics.stream().filter(state -> state.timestamp() >= since).collect(Collectors.toList()));
            }
        }
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCheckOutTime(DefaultConnectionPoolStatistics statistics) {
        int total = 0;
        int min = -1;
        int max = -1;
        LinkedList<Integer> linkedList = this.checkOutTimes;
        synchronized (linkedList) {
            for (Integer time : this.checkOutTimes) {
                total += time.intValue();
                if (min == -1) {
                    min = time;
                    max = time;
                    continue;
                }
                min = Math.min(min, time);
                max = Math.max(max, time);
            }
            statistics.averageCheckOutTime(total / this.checkOutTimes.size());
            statistics.minimumCheckOutTime(min);
            statistics.maximumCheckOutTime(max);
            this.checkOutTimes.clear();
        }
    }

    private final class StatisticsCollector
    implements Runnable {
        private StatisticsCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<DefaultConnectionPoolState> linkedList = DefaultConnectionPoolCounter.this.snapshotStatistics;
            synchronized (linkedList) {
                DefaultConnectionPoolCounter.this.snapshotStatistics.addLast(DefaultConnectionPoolCounter.this.connectionPool.updateState(DefaultConnectionPoolCounter.this.snapshotStatistics.removeFirst()));
            }
        }
    }
}

