/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.pool;

import is.codion.common.db.connection.ConnectionFactory;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.user.User;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public interface ConnectionPoolFactory {
    public ConnectionPoolWrapper createConnectionPool(ConnectionFactory var1, User var2) throws DatabaseException;

    public static ConnectionPoolFactory instance(String classname) {
        Objects.requireNonNull(classname, "classname");
        try {
            return StreamSupport.stream(ServiceLoader.load(ConnectionPoolFactory.class).spliterator(), false).filter(factory -> factory.getClass().getName().equals(classname)).findFirst().orElseThrow(() -> new IllegalStateException("No connection pool factory of type: " + classname + " available"));
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static ConnectionPoolFactory instance() {
        try {
            return (ConnectionPoolFactory)StreamSupport.stream(ServiceLoader.load(ConnectionPoolFactory.class).spliterator(), false).findFirst().orElseThrow(() -> new IllegalStateException("No connection pool factory available"));
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

