/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.pool;

import is.codion.common.db.connection.ConnectionFactory;
import is.codion.common.db.exception.AuthenticationException;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.pool.ConnectionPoolStatistics;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.db.pool.DefaultConnectionPoolCounter;
import is.codion.common.db.pool.DefaultConnectionPoolState;
import is.codion.common.proxy.ProxyBuilder;
import is.codion.common.user.User;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.sql.DataSource;

public abstract class AbstractConnectionPoolWrapper<T>
implements ConnectionPoolWrapper {
    private static final String GET_CONNECTION = "getConnection";
    private static final String CLOSE = "close";
    private final T connectionPool;
    private final ConnectionFactory connectionFactory;
    private final User user;
    private final DefaultConnectionPoolCounter counter;

    protected AbstractConnectionPoolWrapper(ConnectionFactory connectionFactory, User user, DataSource dataSource, Function<DataSource, T> poolFactory) {
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory");
        this.user = Objects.requireNonNull(user, "user");
        this.counter = new DefaultConnectionPoolCounter(this);
        this.connectionPool = Objects.requireNonNull(poolFactory, "poolFactory").apply(this.createDataSourceProxy(Objects.requireNonNull(dataSource, "dataSource")));
    }

    @Override
    public final User user() {
        return this.user;
    }

    @Override
    public final Connection connection(User user) throws DatabaseException {
        Objects.requireNonNull(user, "user");
        this.checkConnectionPoolCredentials(user);
        long startTime = this.counter.isCollectCheckOutTimes() ? System.nanoTime() : 0L;
        try {
            this.counter.incrementRequestCounter();
            Connection connection = this.fetchConnection();
            return connection;
        }
        catch (SQLException e) {
            this.counter.incrementFailedRequestCounter();
            throw new DatabaseException(e);
        }
        finally {
            if (this.counter.isCollectCheckOutTimes() && startTime > 0L) {
                this.counter.addCheckOutTime((int)(System.nanoTime() - startTime) / 1000000);
            }
        }
    }

    @Override
    public final void resetStatistics() {
        this.counter.resetStatistics();
    }

    @Override
    public final boolean isCollectSnapshotStatistics() {
        return this.counter.isCollectSnapshotStatistics();
    }

    @Override
    public final void setCollectSnapshotStatistics(boolean collectSnapshotStatistics) {
        this.counter.setCollectSnapshotStatistics(collectSnapshotStatistics);
    }

    @Override
    public final boolean isCollectCheckOutTimes() {
        return this.counter.isCollectCheckOutTimes();
    }

    @Override
    public final void setCollectCheckOutTimes(boolean collectCheckOutTimes) {
        this.counter.setCollectCheckOutTimes(collectCheckOutTimes);
    }

    @Override
    public final ConnectionPoolStatistics statistics(long since) {
        return this.counter.collectStatistics(since);
    }

    protected abstract Connection fetchConnection() throws SQLException;

    protected final T connectionPool() {
        return this.connectionPool;
    }

    protected abstract int available();

    protected abstract int inUse();

    protected abstract int waiting();

    final DefaultConnectionPoolState updateState(DefaultConnectionPoolState state) {
        return state.set(System.currentTimeMillis(), this.available(), this.inUse(), this.waiting());
    }

    private void checkConnectionPoolCredentials(User user) throws AuthenticationException {
        if (!this.user.username().equalsIgnoreCase(user.username()) || !Arrays.equals(this.user.password(), user.password())) {
            throw new AuthenticationException("Wrong username or password");
        }
    }

    private DataSource createDataSourceProxy(DataSource dataSource) {
        GetConnection getConnection = new GetConnection();
        return (DataSource)ProxyBuilder.builder(DataSource.class).delegate((Object)dataSource).method(GET_CONNECTION, (ProxyBuilder.ProxyMethod)getConnection).method(GET_CONNECTION, Arrays.asList(String.class, String.class), (ProxyBuilder.ProxyMethod)getConnection).build();
    }

    private final class GetConnection
    implements ProxyBuilder.ProxyMethod<DataSource> {
        private GetConnection() {
        }

        public Object invoke(ProxyBuilder.ProxyMethod.Parameters<DataSource> parameters) throws Throwable {
            Connection connection = AbstractConnectionPoolWrapper.this.connectionFactory.createConnection(AbstractConnectionPoolWrapper.this.user);
            AbstractConnectionPoolWrapper.this.counter.incrementConnectionsCreatedCounter();
            return ProxyBuilder.builder(Connection.class).delegate((Object)connection).method(AbstractConnectionPoolWrapper.CLOSE, (ProxyBuilder.ProxyMethod)new Close()).build();
        }
    }

    private final class Close
    implements ProxyBuilder.ProxyMethod<Connection> {
        private Close() {
        }

        public Object invoke(ProxyBuilder.ProxyMethod.Parameters<Connection> parameters) throws Throwable {
            Connection connection = (Connection)parameters.delegate();
            if (!connection.isClosed()) {
                AbstractConnectionPoolWrapper.this.counter.incrementConnectionsDestroyedCounter();
            }
            connection.close();
            return null;
        }
    }
}

