/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.exception;

import java.sql.SQLException;

public class DatabaseException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final transient String statement;
    private final transient int errorCode;
    private final transient String sqlState;

    public DatabaseException(String message) {
        this(message, (String)null);
    }

    public DatabaseException(String message, String statement) {
        super(message);
        this.statement = statement;
        this.errorCode = -1;
        this.sqlState = null;
    }

    public DatabaseException(SQLException cause) {
        this(cause, cause.getMessage());
    }

    public DatabaseException(SQLException cause, String message) {
        this(cause, message, null);
    }

    public DatabaseException(SQLException cause, String message, String statement) {
        super(message);
        this.statement = statement;
        if (cause != null) {
            this.errorCode = cause.getErrorCode();
            this.sqlState = cause.getSQLState();
            this.setStackTrace(cause.getStackTrace());
        } else {
            this.errorCode = -1;
            this.sqlState = null;
        }
    }

    public final String statement() {
        return this.statement;
    }

    public final int errorCode() {
        return this.errorCode;
    }

    public final String sqlState() {
        return this.sqlState;
    }

    @Override
    public final void setStackTrace(StackTraceElement[] stackTrace) {
        super.setStackTrace(stackTrace);
    }
}

