/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.database;

import is.codion.common.db.database.Database;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public interface DatabaseFactory {
    public boolean driverCompatible(String var1);

    public Database createDatabase(String var1);

    public static DatabaseFactory instance() throws SQLException {
        return DatabaseFactory.instance((String)Database.DATABASE_URL.getOrThrow("codion.db.url must be specified before discovering DatabaseFactories"));
    }

    public static DatabaseFactory instance(String url) throws SQLException {
        String driver = DatabaseFactory.driverClassName(url);
        try {
            return StreamSupport.stream(ServiceLoader.load(DatabaseFactory.class).spliterator(), false).filter(factory -> factory.driverCompatible(driver)).findFirst().orElseThrow(() -> new IllegalArgumentException("No DatabaseFactory implementation available for driver: " + driver));
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static String driverClassName(String url) throws SQLException {
        return DriverManager.getDriver(Objects.requireNonNull(url, "url")).getClass().getName();
    }
}

