/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.report;

import is.codion.common.Configuration;
import is.codion.common.db.report.ReportException;
import is.codion.common.property.PropertyValue;
import java.sql.Connection;
import java.util.Objects;

public interface Report<T, R, P> {
    public static final PropertyValue<String> REPORT_PATH = Configuration.stringValue((String)"codion.report.path");
    public static final PropertyValue<Boolean> CACHE_REPORTS = Configuration.booleanValue((String)"codion.report.cacheReports", (boolean)true);

    public R fill(Connection var1, P var2) throws ReportException;

    public T load() throws ReportException;

    public boolean cached();

    public void clearCache();

    public static String reportPath() {
        return (String)REPORT_PATH.getOrThrow();
    }

    public static String fullReportPath(String reportPath) {
        Objects.requireNonNull(reportPath);
        String slash = "/";
        String reportLocation = Report.reportPath();
        StringBuilder builder = new StringBuilder(reportLocation);
        if (!reportLocation.endsWith(slash) && !reportPath.startsWith(slash)) {
            builder.append(slash);
        }
        return builder.append(reportPath).toString();
    }
}

