/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.report;

import is.codion.common.db.report.Report;
import is.codion.common.db.report.ReportException;
import java.util.Objects;

public abstract class AbstractReport<T, R, P>
implements Report<T, R, P> {
    protected final String reportPath;
    private final boolean cacheReport;
    private T cachedReport;

    protected AbstractReport(String reportPath, boolean cacheReport) {
        this.reportPath = Objects.requireNonNull(reportPath, "reportPath");
        this.cacheReport = cacheReport;
    }

    public final String toString() {
        return this.fullReportPath();
    }

    public final boolean equals(Object obj) {
        return obj instanceof AbstractReport && ((AbstractReport)obj).fullReportPath().equals(this.fullReportPath());
    }

    public final int hashCode() {
        return this.fullReportPath().hashCode();
    }

    @Override
    public final synchronized boolean cached() {
        return this.cachedReport != null;
    }

    @Override
    public final synchronized void clearCache() {
        this.cachedReport = null;
    }

    protected String fullReportPath() {
        return Report.fullReportPath(this.reportPath);
    }

    protected final T loadAndCacheReport() throws ReportException {
        if (this.cacheReport) {
            return this.cachedReport();
        }
        return this.load();
    }

    private synchronized T cachedReport() {
        if (this.cachedReport == null) {
            try {
                this.cachedReport = this.load();
            }
            catch (ReportException e) {
                throw new RuntimeException(e);
            }
        }
        return this.cachedReport;
    }
}

