/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.pool;

import is.codion.common.db.connection.ConnectionFactory;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.user.User;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface ConnectionPoolFactory {
    public ConnectionPoolWrapper createConnectionPool(ConnectionFactory var1, User var2) throws DatabaseException;

    public static ConnectionPoolFactory instance(String classname) {
        Objects.requireNonNull(classname, "classname");
        try {
            ServiceLoader<ConnectionPoolFactory> loader = ServiceLoader.load(ConnectionPoolFactory.class);
            for (ConnectionPoolFactory factory : loader) {
                if (!factory.getClass().getName().equals(classname)) continue;
                return factory;
            }
            throw new IllegalStateException("No connection pool factory of type: " + classname + " available");
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static ConnectionPoolFactory instance() {
        try {
            ServiceLoader<ConnectionPoolFactory> loader = ServiceLoader.load(ConnectionPoolFactory.class);
            Iterator<ConnectionPoolFactory> iterator = loader.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            throw new IllegalStateException("No connection pool factory available");
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

