/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.connection;

import is.codion.common.db.connection.DefaultDatabaseConnection;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.logging.MethodLogger;
import is.codion.common.user.User;
import java.sql.Connection;
import java.sql.SQLException;

public interface DatabaseConnection
extends AutoCloseable {
    public static final String SQL_STATE_NO_DATA = "02000";

    public boolean connected();

    public Connection getConnection();

    public void setConnection(Connection var1);

    public void startTransaction();

    public boolean transactionOpen();

    public void commitTransaction();

    public void rollbackTransaction();

    public void commit() throws SQLException;

    public void rollback() throws SQLException;

    @Override
    public void close();

    public User user();

    public Database database();

    public void setMethodLogger(MethodLogger var1);

    public MethodLogger getMethodLogger();

    public static DatabaseConnection databaseConnection(Database database, User user) throws DatabaseException {
        return new DefaultDatabaseConnection(database, user);
    }

    public static DatabaseConnection databaseConnection(Database database, Connection connection) throws DatabaseException {
        return new DefaultDatabaseConnection(database, connection);
    }
}

