/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.database;

import is.codion.common.db.database.Database;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.ServiceLoader;

public interface DatabaseFactory {
    public boolean driverCompatible(String var1);

    public Database createDatabase(String var1);

    public static DatabaseFactory instance() throws SQLException {
        return DatabaseFactory.instance((String)Database.DATABASE_URL.getOrThrow("codion.db.url must be specified before discovering DatabaseFactories"));
    }

    public static DatabaseFactory instance(String url) throws SQLException {
        String driver = DatabaseFactory.driverClassName(url);
        ServiceLoader<DatabaseFactory> loader = ServiceLoader.load(DatabaseFactory.class);
        for (DatabaseFactory factory : loader) {
            if (!factory.driverCompatible(driver)) continue;
            return factory;
        }
        throw new IllegalArgumentException("No DatabaseFactory implementation available for driver: " + driver);
    }

    public static String driverClassName(String url) throws SQLException {
        return DriverManager.getDriver(Objects.requireNonNull(url, "url")).getClass().getName();
    }
}

