/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.database;

import is.codion.common.Configuration;
import is.codion.common.db.connection.ConnectionFactory;
import is.codion.common.db.database.AbstractDatabase;
import is.codion.common.db.database.ConnectionProvider;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.pool.ConnectionPoolFactory;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.property.PropertyValue;
import is.codion.common.user.User;
import java.sql.SQLException;
import java.util.Collection;

public interface Database
extends ConnectionFactory {
    public static final PropertyValue<String> DATABASE_URL = Configuration.stringValue((String)"codion.db.url");
    public static final PropertyValue<String> DATABASE_INIT_SCRIPTS = Configuration.stringValue((String)"codion.db.initScripts");
    public static final PropertyValue<Integer> CONNECTION_VALIDITY_CHECK_TIMEOUT = Configuration.integerValue((String)"codion.db.validityCheckTimeout", (int)2);
    public static final PropertyValue<Boolean> COUNT_QUERIES = Configuration.booleanValue((String)"codion.db.countQueries", (boolean)true);
    public static final PropertyValue<Boolean> SELECT_FOR_UPDATE_NOWAIT = Configuration.booleanValue((String)"codion.db.selectForUpdateNowait", (boolean)true);
    public static final PropertyValue<Integer> LOGIN_TIMEOUT = Configuration.integerValue((String)"codion.db.loginTimeout", (int)2);
    public static final PropertyValue<Integer> TRANSACTION_ISOLATION = Configuration.integerValue((String)"codion.db.transactionIsolation");
    public static final String USER_PROPERTY = "user";
    public static final String PASSWORD_PROPERTY = "password";

    public String name();

    public String autoIncrementQuery(String var1);

    public String sequenceQuery(String var1);

    public String selectForUpdateClause();

    public String limitOffsetClause(Integer var1, Integer var2);

    public boolean subqueryRequiresAlias();

    public int maximumNumberOfParameters();

    public String errorMessage(SQLException var1, Operation var2);

    public DatabaseException databaseException(SQLException var1, Operation var2);

    public boolean isAuthenticationException(SQLException var1);

    public boolean isReferentialIntegrityException(SQLException var1);

    public boolean isUniqueConstraintException(SQLException var1);

    public boolean isTimeoutException(SQLException var1);

    public QueryCounter queryCounter();

    public Statistics statistics();

    public void createConnectionPool(ConnectionPoolFactory var1, User var2) throws DatabaseException;

    public boolean containsConnectionPool(String var1);

    public ConnectionPoolWrapper connectionPool(String var1);

    public Collection<String> connectionPoolUsernames();

    public void closeConnectionPool(String var1);

    public void closeConnectionPools();

    public void connectionProvider(ConnectionProvider var1);

    public static Database instance() {
        return AbstractDatabase.instance();
    }

    public static interface Statistics {
        public int queriesPerSecond();

        public int deletesPerSecond();

        public int insertsPerSecond();

        public int selectsPerSecond();

        public int updatesPerSecond();

        public int otherPerSecond();

        public long timestamp();
    }

    public static interface QueryCounter {
        public void select();

        public void insert();

        public void update();

        public void delete();

        public void other();
    }

    public static enum Operation {
        SELECT,
        UPDATE,
        INSERT,
        DELETE,
        OTHER;

    }
}

