/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.connection;

import is.codion.common.db.connection.DatabaseConnection;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.logging.MethodLogger;
import is.codion.common.user.User;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

final class DefaultDatabaseConnection
implements DatabaseConnection {
    private static final Map<String, User> META_DATA_USER_CACHE = new ConcurrentHashMap<String, User>();
    private final User user;
    private final Database database;
    private Connection connection;
    private boolean transactionOpen = false;
    private MethodLogger methodLogger;

    DefaultDatabaseConnection(Database database, User user) throws DatabaseException {
        this.database = Objects.requireNonNull(database, "database");
        this.connection = DefaultDatabaseConnection.disableAutoCommit(database.createConnection(user));
        this.user = Objects.requireNonNull(user, "user");
    }

    DefaultDatabaseConnection(Database database, Connection connection) throws DatabaseException {
        this.database = Objects.requireNonNull(database, "database");
        this.connection = DefaultDatabaseConnection.disableAutoCommit(connection);
        this.user = DefaultDatabaseConnection.user(connection);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.user.username();
    }

    @Override
    public User user() {
        return this.user;
    }

    @Override
    public void setMethodLogger(MethodLogger methodLogger) {
        this.methodLogger = methodLogger;
    }

    @Override
    public MethodLogger getMethodLogger() {
        return this.methodLogger;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.rollback();
            }
        }
        catch (SQLException ex) {
            System.err.println("DefaultDatabaseConnection.close(), connection invalid");
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = null;
        this.transactionOpen = false;
    }

    @Override
    public boolean connected() {
        return this.connection != null && this.database.connectionValid(this.connection);
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Database database() {
        return this.database;
    }

    @Override
    public void beginTransaction() {
        this.verifyOpenConnection();
        if (this.transactionOpen) {
            throw new IllegalStateException("Transaction already open");
        }
        this.logEntry("beginTransaction");
        this.transactionOpen = true;
        this.logExit("beginTransaction", null);
    }

    @Override
    public void rollbackTransaction() {
        this.verifyOpenConnection();
        SQLException exception = null;
        try {
            if (!this.transactionOpen) {
                throw new IllegalStateException("Transaction is not open");
            }
            this.logEntry("rollbackTransaction");
            this.connection.rollback();
        }
        catch (SQLException e) {
            exception = e;
        }
        finally {
            this.transactionOpen = false;
            this.logExit("rollbackTransaction", exception);
        }
    }

    @Override
    public void commitTransaction() {
        this.verifyOpenConnection();
        SQLException exception = null;
        try {
            if (!this.transactionOpen) {
                throw new IllegalStateException("Transaction is not open");
            }
            this.logEntry("commitTransaction");
            this.connection.commit();
        }
        catch (SQLException e) {
            exception = e;
        }
        finally {
            this.transactionOpen = false;
            this.logExit("commitTransaction", exception);
        }
    }

    @Override
    public boolean transactionOpen() {
        return this.transactionOpen;
    }

    @Override
    public void commit() throws SQLException {
        this.verifyOpenConnection();
        if (this.transactionOpen) {
            throw new IllegalStateException("Can not perform a commit during an open transaction, use 'commitTransaction()'");
        }
        SQLException exception = null;
        try {
            this.logEntry("commit");
            this.connection.commit();
        }
        catch (SQLException e) {
            System.err.println("Exception during commit: " + this.user.username() + ": " + e.getMessage());
            exception = e;
            throw e;
        }
        finally {
            this.logExit("commit", exception);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.verifyOpenConnection();
        if (this.transactionOpen) {
            throw new IllegalStateException("Can not perform a rollback during an open transaction, use 'rollbackTransaction()'");
        }
        this.logEntry("rollback");
        SQLException exception = null;
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            exception = e;
            throw e;
        }
        finally {
            this.logExit("rollback", exception);
        }
    }

    private void logEntry(String method) {
        if (this.methodLogger != null && this.methodLogger.isEnabled()) {
            this.methodLogger.enter(method);
        }
    }

    private MethodLogger.Entry logExit(String method, Exception exception) {
        if (this.methodLogger != null && this.methodLogger.isEnabled()) {
            return this.methodLogger.exit(method, exception);
        }
        return null;
    }

    private void verifyOpenConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    private static Connection disableAutoCommit(Connection connection) throws DatabaseException {
        Objects.requireNonNull(connection, "connection");
        try {
            connection.setAutoCommit(false);
            return connection;
        }
        catch (SQLException e) {
            System.err.println("Unable to disable auto commit on connection, assuming invalid state");
            throw new DatabaseException(e, "Connection invalid during instantiation");
        }
    }

    private static User user(Connection connection) throws DatabaseException {
        try {
            return META_DATA_USER_CACHE.computeIfAbsent(connection.getMetaData().getUserName(), User::user);
        }
        catch (SQLException e) {
            throw new DatabaseException(e, "Exception while trying to retrieve username from meta data");
        }
    }
}

