/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.pool;

import is.codion.common.db.connection.ConnectionFactory;
import is.codion.common.db.exception.AuthenticationException;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.pool.ConnectionPoolStatistics;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.db.pool.DefaultConnectionPoolCounter;
import is.codion.common.db.pool.DefaultConnectionPoolState;
import is.codion.common.user.User;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import javax.sql.DataSource;

public abstract class AbstractConnectionPoolWrapper<T>
implements ConnectionPoolWrapper {
    private T pool;
    private final ConnectionFactory connectionFactory;
    private final User user;
    private final DataSource poolDataSource;
    private final DefaultConnectionPoolCounter counter;

    protected AbstractConnectionPoolWrapper(ConnectionFactory connectionFactory, User user, DataSource poolDataSource) {
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory");
        this.user = Objects.requireNonNull(user, "user");
        this.poolDataSource = (DataSource)Proxy.newProxyInstance(DataSource.class.getClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)new DataSourceInvocationHandler(Objects.requireNonNull(poolDataSource, "poolDataSource")));
        this.counter = new DefaultConnectionPoolCounter(this);
    }

    @Override
    public final User user() {
        return this.user;
    }

    @Override
    public final DataSource poolDataSource() {
        return this.poolDataSource;
    }

    @Override
    public final Connection connection(User user) throws DatabaseException {
        Objects.requireNonNull(user, "user");
        this.checkConnectionPoolCredentials(user);
        long startTime = this.counter.isCollectCheckOutTimes() ? System.nanoTime() : 0L;
        try {
            this.counter.incrementRequestCounter();
            Connection connection = this.fetchConnection();
            return connection;
        }
        catch (SQLException e) {
            this.counter.incrementFailedRequestCounter();
            throw new DatabaseException(e);
        }
        finally {
            if (this.counter.isCollectCheckOutTimes() && startTime > 0L) {
                this.counter.addCheckOutTime((int)(System.nanoTime() - startTime) / 1000000);
            }
        }
    }

    @Override
    public final void resetStatistics() {
        this.counter.resetStatistics();
    }

    @Override
    public final boolean isCollectSnapshotStatistics() {
        return this.counter.isCollectSnapshotStatistics();
    }

    @Override
    public final void setCollectSnapshotStatistics(boolean collectSnapshotStatistics) {
        this.counter.setCollectSnapshotStatistics(collectSnapshotStatistics);
    }

    @Override
    public final boolean isCollectCheckOutTimes() {
        return this.counter.isCollectCheckOutTimes();
    }

    @Override
    public final void setCollectCheckOutTimes(boolean collectCheckOutTimes) {
        this.counter.setCollectCheckOutTimes(collectCheckOutTimes);
    }

    @Override
    public final ConnectionPoolStatistics statistics(long since) {
        return this.counter.collectStatistics(since);
    }

    protected abstract Connection fetchConnection() throws SQLException;

    protected final void setPool(T pool) {
        this.pool = Objects.requireNonNull(pool, "pool");
    }

    protected final T getPool() {
        return this.pool;
    }

    protected abstract int available();

    protected abstract int inUse();

    protected abstract int waiting();

    final DefaultConnectionPoolState updateState(DefaultConnectionPoolState state) {
        return state.set(System.currentTimeMillis(), this.available(), this.inUse(), this.waiting());
    }

    private void checkConnectionPoolCredentials(User user) throws AuthenticationException {
        if (!this.user.username().equalsIgnoreCase(user.username()) || !Arrays.equals(this.user.password(), user.password())) {
            throw new AuthenticationException("Wrong username or password");
        }
    }

    private final class DataSourceInvocationHandler
    implements InvocationHandler {
        private final DataSource dataSource;

        private DataSourceInvocationHandler(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getConnection".equals(method.getName())) {
                Connection connection = AbstractConnectionPoolWrapper.this.connectionFactory.createConnection(AbstractConnectionPoolWrapper.this.user);
                AbstractConnectionPoolWrapper.this.counter.incrementConnectionsCreatedCounter();
                return Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(connection));
            }
            return method.invoke((Object)this.dataSource, args);
        }
    }

    private final class ConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection connection;

        private ConnectionInvocationHandler(Connection connection) {
            this.connection = connection;
        }

        @Override
        public Object invoke(Object connectionProxy, Method connectionMethod, Object[] connectionArgs) throws Throwable {
            if ("close".equals(connectionMethod.getName()) && !this.connection.isClosed()) {
                AbstractConnectionPoolWrapper.this.counter.incrementConnectionsDestroyedCounter();
            }
            return connectionMethod.invoke((Object)this.connection, connectionArgs);
        }
    }
}

