/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.db.database;

import is.codion.common.db.database.ConnectionProvider;
import is.codion.common.db.database.Database;
import is.codion.common.db.database.DatabaseFactory;
import is.codion.common.db.exception.AuthenticationException;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.pool.ConnectionPoolFactory;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.user.User;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractDatabase
implements Database {
    protected static final String FOR_UPDATE = "FOR UPDATE";
    protected static final String FOR_UPDATE_NOWAIT = "FOR UPDATE NOWAIT";
    private static final String FETCH_NEXT = "FETCH NEXT ";
    private static final String ROWS = " ROWS";
    private static final String ONLY = " ONLY";
    private static final String OFFSET = "OFFSET ";
    private static final String LIMIT = "LIMIT ";
    private static Database instance;
    private final Map<String, ConnectionPoolWrapper> connectionPools = new HashMap<String, ConnectionPoolWrapper>();
    private final int validityCheckTimeout = (Integer)CONNECTION_VALIDITY_CHECK_TIMEOUT.get();
    private final DefaultQueryCounter queryCounter = new DefaultQueryCounter();
    private final String url;
    private ConnectionProvider connectionProvider = new ConnectionProvider(){};

    protected AbstractDatabase(String url) {
        this.url = Objects.requireNonNull(url, "url");
    }

    @Override
    public final String url() {
        return this.url;
    }

    @Override
    public final Connection createConnection(User user) throws DatabaseException {
        DriverManager.setLoginTimeout(this.loginTimeout());
        try {
            Connection connection = this.connectionProvider.connection(user, this.url);
            if (Database.TRANSACTION_ISOLATION.isNotNull()) {
                connection.setTransactionIsolation((Integer)Database.TRANSACTION_ISOLATION.get());
            }
            return connection;
        }
        catch (SQLException e) {
            if (this.isAuthenticationException(e)) {
                throw new AuthenticationException(e.getMessage());
            }
            throw new DatabaseException(e, this.errorMessage(e, Database.Operation.OTHER));
        }
    }

    @Override
    public final boolean connectionValid(Connection connection) {
        Objects.requireNonNull(connection, "connection");
        try {
            return connection.isValid(this.validityCheckTimeout);
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public final Database.QueryCounter queryCounter() {
        return this.queryCounter;
    }

    @Override
    public final Database.Statistics statistics() {
        return this.queryCounter.collectAndResetStatistics();
    }

    @Override
    public final void createConnectionPool(ConnectionPoolFactory connectionPoolFactory, User poolUser) throws DatabaseException {
        Objects.requireNonNull(connectionPoolFactory, "connectionPoolFactory");
        Objects.requireNonNull(poolUser, "poolUser");
        if (this.connectionPools.containsKey(poolUser.username().toLowerCase())) {
            throw new IllegalStateException("Connection pool for user " + poolUser.username() + " has already been created");
        }
        this.connectionPools.put(poolUser.username().toLowerCase(), connectionPoolFactory.createConnectionPool(this, poolUser));
    }

    @Override
    public final ConnectionPoolWrapper connectionPool(String username) {
        return this.connectionPools.get(Objects.requireNonNull(username, "username").toLowerCase());
    }

    @Override
    public final void closeConnectionPool(String username) {
        ConnectionPoolWrapper connectionPoolWrapper = this.connectionPools.remove(Objects.requireNonNull(username, "username").toLowerCase());
        if (connectionPoolWrapper != null) {
            connectionPoolWrapper.close();
        }
    }

    @Override
    public final void closeConnectionPools() {
        for (ConnectionPoolWrapper pool : this.connectionPools.values()) {
            this.closeConnectionPool(pool.user().username());
        }
    }

    @Override
    public final Collection<String> connectionPoolUsernames() {
        return new ArrayList<String>(this.connectionPools.keySet());
    }

    @Override
    public final void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider == null ? new ConnectionProvider(){} : connectionProvider;
    }

    @Override
    public boolean subqueryRequiresAlias() {
        return false;
    }

    @Override
    public int maximumNumberOfParameters() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int validityCheckTimeout() {
        return this.validityCheckTimeout;
    }

    @Override
    public String sequenceQuery(String sequenceName) {
        throw new UnsupportedOperationException("Sequence support is not implemented for database: " + this.getClass().getSimpleName());
    }

    @Override
    public String errorMessage(SQLException exception, Database.Operation operation) {
        return exception.getMessage();
    }

    @Override
    public boolean isAuthenticationException(SQLException exception) {
        return false;
    }

    @Override
    public boolean isReferentialIntegrityException(SQLException exception) {
        return false;
    }

    @Override
    public boolean isUniqueConstraintException(SQLException exception) {
        return false;
    }

    @Override
    public boolean isTimeoutException(SQLException exception) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database instance() {
        try {
            Class<AbstractDatabase> clazz = AbstractDatabase.class;
            synchronized (AbstractDatabase.class) {
                String databaseUrl = (String)DATABASE_URL.get();
                if (instance == null || !instance.url().equals(databaseUrl)) {
                    Database previousInstance = instance;
                    instance = DatabaseFactory.instance().createDatabase(databaseUrl);
                    if (previousInstance != null) {
                        previousInstance.closeConnectionPools();
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int loginTimeout() {
        return (Integer)Database.LOGIN_TIMEOUT.getOrThrow();
    }

    protected static String createLimitOffsetClause(Integer limit, Integer offset) {
        StringBuilder builder = new StringBuilder();
        if (limit != null) {
            builder.append(LIMIT).append(limit);
        }
        if (offset != null) {
            builder.append(builder.length() == 0 ? "" : " ").append(OFFSET).append(offset);
        }
        return builder.toString();
    }

    protected static String createOffsetFetchNextClause(Integer limit, Integer offset) {
        StringBuilder builder = new StringBuilder();
        if (offset != null) {
            builder.append(OFFSET).append(offset).append(ROWS);
        }
        if (limit != null) {
            builder.append(builder.length() == 0 ? "" : " ").append(FETCH_NEXT).append(limit).append(ROWS).append(ONLY);
        }
        return builder.toString();
    }

    protected static String removeUrlPrefixOptionsAndParameters(String url, String ... prefixes) {
        String result = url;
        for (String prefix : prefixes) {
            if (!url.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            result = url.substring(prefix.length());
            break;
        }
        if (result.contains(";")) {
            result = result.substring(0, result.indexOf(59));
        }
        if (result.contains("?")) {
            result = result.substring(0, result.indexOf(63));
        }
        return result;
    }

    private static final class DefaultQueryCounter
    implements Database.QueryCounter {
        private static final double THOUSAND = 1000.0;
        private final AtomicLong queriesPerSecondTime = new AtomicLong(System.currentTimeMillis());
        private final AtomicInteger queriesPerSecondCounter = new AtomicInteger();
        private final AtomicInteger selectsPerSecondCounter = new AtomicInteger();
        private final AtomicInteger insertsPerSecondCounter = new AtomicInteger();
        private final AtomicInteger updatesPerSecondCounter = new AtomicInteger();
        private final AtomicInteger deletesPerSecondCounter = new AtomicInteger();
        private final AtomicInteger otherPerSecondCounter = new AtomicInteger();
        private final boolean enabled = (Boolean)Database.COUNT_QUERIES.get();

        private DefaultQueryCounter() {
        }

        @Override
        public void select() {
            if (this.enabled) {
                this.selectsPerSecondCounter.incrementAndGet();
                this.queriesPerSecondCounter.incrementAndGet();
            }
        }

        @Override
        public void insert() {
            if (this.enabled) {
                this.insertsPerSecondCounter.incrementAndGet();
                this.queriesPerSecondCounter.incrementAndGet();
            }
        }

        @Override
        public void update() {
            if (this.enabled) {
                this.updatesPerSecondCounter.incrementAndGet();
                this.queriesPerSecondCounter.incrementAndGet();
            }
        }

        @Override
        public void delete() {
            if (this.enabled) {
                this.deletesPerSecondCounter.incrementAndGet();
                this.queriesPerSecondCounter.incrementAndGet();
            }
        }

        @Override
        public void other() {
            if (this.enabled) {
                this.otherPerSecondCounter.incrementAndGet();
                this.queriesPerSecondCounter.incrementAndGet();
            }
        }

        private Database.Statistics collectAndResetStatistics() {
            long currentTime = System.currentTimeMillis();
            double seconds = (double)(currentTime - this.queriesPerSecondTime.getAndSet(currentTime)) / 1000.0;
            if (seconds > 0.0) {
                int queriesPerSecond = (int)((double)this.queriesPerSecondCounter.getAndSet(0) / seconds);
                int selectsPerSecond = (int)((double)this.selectsPerSecondCounter.getAndSet(0) / seconds);
                int insertsPerSecond = (int)((double)this.insertsPerSecondCounter.getAndSet(0) / seconds);
                int deletesPerSecond = (int)((double)this.deletesPerSecondCounter.getAndSet(0) / seconds);
                int updatesPerSecond = (int)((double)this.updatesPerSecondCounter.getAndSet(0) / seconds);
                int otherPerSecond = (int)((double)this.otherPerSecondCounter.getAndSet(0) / seconds);
                return new DefaultDatabaseStatistics(currentTime, queriesPerSecond, selectsPerSecond, insertsPerSecond, deletesPerSecond, updatesPerSecond, otherPerSecond);
            }
            return new DefaultDatabaseStatistics();
        }
    }

    private static final class DefaultDatabaseStatistics
    implements Database.Statistics,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long timestamp;
        private final int queriesPerSecond;
        private final int selectsPerSecond;
        private final int insertsPerSecond;
        private final int deletesPerSecond;
        private final int updatesPerSecond;
        private final int otherPerSecond;

        private DefaultDatabaseStatistics() {
            this(0L, 0, 0, 0, 0, 0, 0);
        }

        private DefaultDatabaseStatistics(long timestamp, int queriesPerSecond, int selectsPerSecond, int insertsPerSecond, int deletesPerSecond, int updatesPerSecond, int otherPerSecond) {
            this.timestamp = timestamp;
            this.queriesPerSecond = queriesPerSecond;
            this.selectsPerSecond = selectsPerSecond;
            this.insertsPerSecond = insertsPerSecond;
            this.deletesPerSecond = deletesPerSecond;
            this.updatesPerSecond = updatesPerSecond;
            this.otherPerSecond = otherPerSecond;
        }

        @Override
        public int queriesPerSecond() {
            return this.queriesPerSecond;
        }

        @Override
        public int deletesPerSecond() {
            return this.deletesPerSecond;
        }

        @Override
        public int insertsPerSecond() {
            return this.insertsPerSecond;
        }

        @Override
        public int selectsPerSecond() {
            return this.selectsPerSecond;
        }

        @Override
        public int updatesPerSecond() {
            return this.updatesPerSecond;
        }

        @Override
        public int otherPerSecond() {
            return this.otherPerSecond;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }
    }
}

