/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.DefaultValueSet;
import is.codion.common.value.ValueSetObserver;
import is.codion.common.value.Values;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public interface ValueSet<T>
extends Values<T, Set<T>> {
    @Override
    public ValueSetObserver<T> observer();

    public static <T> ValueSet<T> valueSet() {
        return ValueSet.builder(Collections.emptySet()).build();
    }

    public static <T> ValueSet<T> valueSet(Collection<T> initialValue) {
        return ValueSet.builder(initialValue).build();
    }

    public static <T> Builder<T> builder() {
        return ValueSet.builder(Collections.emptySet());
    }

    public static <T> Builder<T> builder(Collection<T> initialValue) {
        Objects.requireNonNull(initialValue);
        return (Builder)new DefaultValueSet.DefaultBuilder<LinkedHashSet<T>>().initialValue(new LinkedHashSet<T>(initialValue));
    }

    public static interface Builder<T>
    extends Values.Builder<T, Set<T>, Builder<T>> {
        @Override
        public ValueSet<T> build();
    }
}

