/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.DefaultValueList;
import is.codion.common.value.ValueListObserver;
import is.codion.common.value.Values;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface ValueList<T>
extends Values<T, List<T>> {
    @Override
    public ValueListObserver<T> observer();

    public static <T> ValueList<T> valueList() {
        return ValueList.builder(Collections.emptyList()).build();
    }

    public static <T> ValueList<T> valueList(Collection<T> initialValue) {
        return ValueList.builder(initialValue).build();
    }

    public static <T> Builder<T> builder() {
        return ValueList.builder(Collections.emptyList());
    }

    public static <T> Builder<T> builder(Collection<T> initialValue) {
        Objects.requireNonNull(initialValue);
        return (Builder)new DefaultValueList.DefaultBuilder<ArrayList<T>>().initialValue(new ArrayList<T>(initialValue));
    }

    public static interface Builder<T>
    extends Values.Builder<T, List<T>, Builder<T>> {
        @Override
        public ValueList<T> build();
    }
}

