/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.AbstractValue;
import is.codion.common.value.DefaultValue;
import is.codion.common.value.DefaultValuesObserver;
import is.codion.common.value.Value;
import is.codion.common.value.Values;
import is.codion.common.value.ValuesObserver;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

class DefaultValues<T, C extends Collection<T>>
extends DefaultValue<C>
implements Values<T, C> {
    private final Supplier<? extends C> create;
    private final Function<C, C> unmodifiable;
    private Value<T> singleValue;

    DefaultValues(DefaultBuilder<C, T, ?> builder) {
        super(builder);
        this.create = builder.create;
        this.unmodifiable = builder.unmodifiable;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.get().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean set(Collection<T> values) {
        Object object = this.lock;
        synchronized (object) {
            Collection newValues = (Collection)this.create.get();
            if (values != null) {
                newValues.addAll(values);
            }
            return this.set((Collection)this.unmodifiable.apply(newValues));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final C get() {
        Object object = this.lock;
        synchronized (object) {
            return (C)((Collection)super.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean add(T value) {
        Object object = this.lock;
        synchronized (object) {
            Collection newValues = (Collection)this.create.get();
            newValues.addAll(this.get());
            boolean added = newValues.add(value);
            this.set((Collection)this.unmodifiable.apply(newValues));
            return added;
        }
    }

    @Override
    public final boolean addAll(T ... values) {
        return this.addAll((Collection<T>)Arrays.asList(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addAll(Collection<T> values) {
        Objects.requireNonNull(values);
        Object object = this.lock;
        synchronized (object) {
            Collection newValues = (Collection)this.create.get();
            newValues.addAll(this.get());
            boolean added = newValues.addAll(values);
            this.set((Collection)this.unmodifiable.apply(newValues));
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(T value) {
        Object object = this.lock;
        synchronized (object) {
            Collection newValues = (Collection)this.create.get();
            newValues.addAll(this.get());
            boolean removed = newValues.remove(value);
            this.set((Collection)this.unmodifiable.apply(newValues));
            return removed;
        }
    }

    @Override
    public final boolean removeAll(T ... values) {
        return this.removeAll((Collection<T>)Arrays.asList(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeAll(Collection<T> values) {
        Objects.requireNonNull(values);
        Object object = this.lock;
        synchronized (object) {
            Collection newValues = (Collection)this.create.get();
            newValues.addAll(this.get());
            boolean removed = newValues.removeAll(values);
            this.set((Collection)this.unmodifiable.apply(newValues));
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean contains(T value) {
        Object object = this.lock;
        synchronized (object) {
            return this.get().contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsAll(Collection<T> values) {
        Objects.requireNonNull(values);
        Object object = this.lock;
        synchronized (object) {
            return this.get().containsAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean empty() {
        Object object = this.lock;
        synchronized (object) {
            return this.get().isEmpty();
        }
    }

    @Override
    public final boolean notEmpty() {
        return !this.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.get().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Value<T> value() {
        Object object = this.lock;
        synchronized (object) {
            if (this.singleValue == null) {
                this.singleValue = new SingleValue();
            }
            return this.singleValue;
        }
    }

    @Override
    public final boolean isNull() {
        return false;
    }

    @Override
    public synchronized ValuesObserver<T, C> observer() {
        return (ValuesObserver)super.observer();
    }

    protected ValuesObserver<T, C> createObserver() {
        return new DefaultValuesObserver(this);
    }

    static class DefaultBuilder<C extends Collection<T>, T, B extends Values.Builder<T, C, B>>
    extends DefaultValue.DefaultBuilder<C, B>
    implements Values.Builder<T, C, B> {
        private final Supplier<C> create;
        private final Function<C, C> unmodifiable;

        DefaultBuilder(Supplier<C> create, Function<C, C> unmodifiable) {
            super((Collection)Objects.requireNonNull(unmodifiable).apply((Collection)Objects.requireNonNull(create).get()));
            this.create = create;
            this.unmodifiable = unmodifiable;
        }

        @Override
        public Values<T, C> build() {
            return new DefaultValues(this);
        }

        @Override
        protected C prepareInitialValue() {
            return (C)((Collection)this.unmodifiable.apply((Collection)super.prepareInitialValue()));
        }
    }

    private final class SingleValue
    extends AbstractValue<T> {
        private SingleValue() {
            super(null);
            DefaultValues.this.addListener(this::notifyListeners);
        }

        @Override
        public T get() {
            Object collection = DefaultValues.this.get();
            return collection.isEmpty() ? null : (Object)collection.iterator().next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setValue(T value) {
            DefaultValues defaultValues = DefaultValues.this;
            synchronized (defaultValues) {
                DefaultValues.this.set(value == null ? Collections.emptyList() : Collections.singleton(value));
            }
        }
    }
}

