/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

class DefaultValue<T>
extends AbstractValue<T> {
    protected final Object lock = new Object();
    private T value;

    protected DefaultValue(DefaultBuilder<T, ?> builder) {
        super(builder.nullValue, builder.notify);
        this.value = builder.prepareInitialValue();
        builder.validators.forEach(this::addValidator);
        builder.linkedValues.forEach(this::link);
        builder.linkedObservers.forEach(this::link);
        builder.listeners.forEach(this::addListener);
        builder.weakListeners.forEach(this::addWeakListener);
        builder.consumers.forEach(this::addConsumer);
        builder.weakConsumers.forEach(this::addWeakConsumer);
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    protected final void setValue(T value) {
        this.value = value;
    }

    static class DefaultBuilder<T, B extends Value.Builder<T, B>>
    implements Value.Builder<T, B> {
        private final T nullValue;
        private final List<Value.Validator<? super T>> validators = new ArrayList<Value.Validator<? super T>>();
        private final List<Value<T>> linkedValues = new ArrayList<Value<T>>();
        private final List<ValueObserver<T>> linkedObservers = new ArrayList<ValueObserver<T>>();
        private final List<Runnable> listeners = new ArrayList<Runnable>();
        private final List<Runnable> weakListeners = new ArrayList<Runnable>();
        private final List<Consumer<? super T>> consumers = new ArrayList<Consumer<? super T>>();
        private final List<Consumer<? super T>> weakConsumers = new ArrayList<Consumer<? super T>>();
        private T initialValue;
        private Value.Notify notify = Value.Notify.WHEN_CHANGED;

        DefaultBuilder() {
            this.nullValue = null;
        }

        DefaultBuilder(T nullValue) {
            this.nullValue = Objects.requireNonNull(nullValue);
            this.initialValue = nullValue;
        }

        @Override
        public final B initialValue(T initialValue) {
            this.initialValue = initialValue;
            return this.self();
        }

        @Override
        public final B notify(Value.Notify notify) {
            this.notify = Objects.requireNonNull(notify);
            return this.self();
        }

        @Override
        public final B validator(Value.Validator<? super T> validator) {
            this.validators.add(Objects.requireNonNull(validator));
            return this.self();
        }

        @Override
        public final B link(Value<T> originalValue) {
            this.linkedValues.add(Objects.requireNonNull(originalValue));
            return this.self();
        }

        @Override
        public final B link(ValueObserver<T> originalValue) {
            this.linkedObservers.add(Objects.requireNonNull(originalValue));
            return this.self();
        }

        @Override
        public final B listener(Runnable listener) {
            this.listeners.add(Objects.requireNonNull(listener));
            return this.self();
        }

        @Override
        public final B consumer(Consumer<? super T> consumer) {
            this.consumers.add(Objects.requireNonNull(consumer));
            return this.self();
        }

        @Override
        public final B weakListener(Runnable weakListener) {
            this.weakListeners.add(Objects.requireNonNull(weakListener));
            return this.self();
        }

        @Override
        public final B weakConsumer(Consumer<? super T> weakConsumer) {
            this.weakConsumers.add(Objects.requireNonNull(weakConsumer));
            return this.self();
        }

        @Override
        public Value<T> build() {
            return new DefaultValue(this);
        }

        protected T prepareInitialValue() {
            return this.initialValue == null ? this.nullValue : this.initialValue;
        }

        private B self() {
            return (B)this;
        }
    }
}

