/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.value;

import is.codion.common.event.Event;
import is.codion.common.value.DefaultValueObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueLink;
import is.codion.common.value.ValueObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractValue<T>
implements Value<T> {
    private final T nullValue;
    private final Value.Notify notify;
    private Event<T> changeEvent;
    private Set<Value.Validator<? super T>> validators;
    private Map<Value<T>, ValueLink<T>> linkedValues;
    private Consumer<T> originalValueConsumer;
    private ValueObserver<T> observer;

    protected AbstractValue() {
        this(null);
    }

    protected AbstractValue(T nullValue) {
        this.nullValue = nullValue;
        this.notify = null;
    }

    protected AbstractValue(T nullValue, Value.Notify notify) {
        this.nullValue = nullValue;
        this.notify = Objects.requireNonNull(notify);
    }

    @Override
    public final boolean set(T value) {
        T newValue = value == null ? this.nullValue : value;
        for (Value.Validator<T> validator : this.validators()) {
            validator.validate(newValue);
        }
        Object previousValue = this.get();
        this.setValue(newValue);
        return this.notifyListeners(!Objects.equals(previousValue, newValue));
    }

    @Override
    public final void clear() {
        this.clearValue();
    }

    @Override
    public final boolean map(Function<T, T> mapper) {
        return this.set(Objects.requireNonNull(mapper).apply(this.get()));
    }

    @Override
    public synchronized ValueObserver<T> observer() {
        if (this.observer == null) {
            this.observer = this.createObserver();
        }
        return this.observer;
    }

    @Override
    public final boolean isNullable() {
        return this.nullValue == null;
    }

    @Override
    public final void accept(T data) {
        this.set(data);
    }

    @Override
    public final boolean addListener(Runnable listener) {
        return this.changeEvent().addListener(listener);
    }

    @Override
    public final boolean removeListener(Runnable listener) {
        if (this.changeEvent != null) {
            return this.changeEvent.removeListener(listener);
        }
        return false;
    }

    @Override
    public final boolean addConsumer(Consumer<? super T> consumer) {
        return this.changeEvent().addConsumer(consumer);
    }

    @Override
    public final boolean removeConsumer(Consumer<? super T> consumer) {
        if (this.changeEvent != null) {
            return this.changeEvent.removeConsumer(consumer);
        }
        return false;
    }

    @Override
    public final boolean addWeakListener(Runnable listener) {
        return this.changeEvent().addWeakListener(listener);
    }

    @Override
    public final boolean removeWeakListener(Runnable listener) {
        if (this.changeEvent != null) {
            return this.changeEvent.removeWeakListener(listener);
        }
        return false;
    }

    @Override
    public final boolean addWeakConsumer(Consumer<? super T> consumer) {
        return this.changeEvent().addWeakConsumer(consumer);
    }

    @Override
    public final boolean removeWeakConsumer(Consumer<? super T> consumer) {
        if (this.changeEvent != null) {
            return this.changeEvent.removeWeakConsumer(consumer);
        }
        return false;
    }

    @Override
    public final void link(Value<T> originalValue) {
        Objects.requireNonNull(originalValue);
        if (this.linkedValues == null) {
            this.linkedValues = new LinkedHashMap<Value<T>, ValueLink<T>>(1);
        }
        if (this.linkedValues.containsKey(originalValue)) {
            throw new IllegalStateException("Values are already linked");
        }
        this.linkedValues.put(originalValue, new ValueLink<T>(this, originalValue));
    }

    @Override
    public final void unlink(Value<T> originalValue) {
        Objects.requireNonNull(originalValue);
        if (this.linkedValues != null) {
            if (!this.linkedValues.containsKey(originalValue)) {
                throw new IllegalStateException("Values are not linked");
            }
            this.linkedValues.remove(originalValue).unlink();
        }
    }

    @Override
    public final void link(ValueObserver<T> originalValue) {
        Objects.requireNonNull(originalValue);
        if (this.originalValueConsumer == null) {
            this.originalValueConsumer = new OriginalValueConsumer();
        }
        this.set(originalValue.get());
        originalValue.addConsumer(this.originalValueConsumer);
    }

    @Override
    public final void unlink(ValueObserver<T> originalValue) {
        Objects.requireNonNull(originalValue);
        if (this.originalValueConsumer != null) {
            originalValue.removeConsumer(this.originalValueConsumer);
        }
    }

    @Override
    public final boolean addValidator(Value.Validator<? super T> validator) {
        Objects.requireNonNull(validator, "validator").validate(this.get());
        if (this.validators == null) {
            this.validators = new LinkedHashSet<Value.Validator<? super T>>(1);
        }
        return this.validators.add(validator);
    }

    @Override
    public final boolean removeValidator(Value.Validator<? super T> validator) {
        Objects.requireNonNull(validator, "validator");
        if (this.validators != null) {
            return this.validators.remove(validator);
        }
        return false;
    }

    @Override
    public final void validate(T value) {
        this.validators().forEach(validator -> validator.validate(value));
    }

    protected abstract void setValue(T var1);

    protected void clearValue() {
        this.set(null);
    }

    protected final void notifyListeners() {
        if (this.changeEvent != null) {
            this.changeEvent.accept(this.get());
        }
    }

    protected ValueObserver<T> createObserver() {
        return new DefaultValueObserver(this);
    }

    final Set<Value<T>> linkedValues() {
        return this.linkedValues == null ? Collections.emptySet() : this.linkedValues.keySet();
    }

    final Collection<Value.Validator<? super T>> validators() {
        return this.validators == null ? Collections.emptyList() : this.validators;
    }

    private boolean notifyListeners(boolean changed) {
        if (this.notify == Value.Notify.WHEN_SET || this.notify == Value.Notify.WHEN_CHANGED && changed) {
            this.notifyListeners();
        }
        return changed;
    }

    private synchronized Event<T> changeEvent() {
        if (this.changeEvent == null) {
            this.changeEvent = Event.event();
        }
        return this.changeEvent;
    }

    private final class OriginalValueConsumer
    implements Consumer<T> {
        private OriginalValueConsumer() {
        }

        @Override
        public void accept(T value) {
            AbstractValue.this.set(value);
        }
    }
}

