/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.state;

import is.codion.common.Conjunction;
import is.codion.common.state.DefaultState;
import is.codion.common.state.DefaultStateCombination;
import is.codion.common.state.DefaultStateGroup;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import java.util.Collection;
import java.util.function.Consumer;

public interface State
extends StateObserver,
Value<Boolean> {
    public StateObserver observer();

    public static State state() {
        return State.state(false);
    }

    public static State state(boolean value) {
        return State.builder(value).build();
    }

    public static Builder builder() {
        return State.builder(false);
    }

    public static Builder builder(boolean value) {
        return new DefaultState.DefaultBuilder(value);
    }

    public static Combination combination(Conjunction conjunction, StateObserver ... stateObservers) {
        return new DefaultStateCombination(conjunction, stateObservers);
    }

    public static Combination combination(Conjunction conjunction, Collection<? extends StateObserver> stateObservers) {
        return new DefaultStateCombination(conjunction, stateObservers);
    }

    public static Combination and(StateObserver ... stateObservers) {
        return new DefaultStateCombination(Conjunction.AND, stateObservers);
    }

    public static Combination and(Collection<? extends StateObserver> stateObservers) {
        return new DefaultStateCombination(Conjunction.AND, stateObservers);
    }

    public static Combination or(StateObserver ... stateObservers) {
        return new DefaultStateCombination(Conjunction.OR, stateObservers);
    }

    public static Combination or(Collection<? extends StateObserver> stateObservers) {
        return new DefaultStateCombination(Conjunction.OR, stateObservers);
    }

    public static Group group(State ... states) {
        return new DefaultStateGroup(states);
    }

    public static Group group(Collection<State> states) {
        return new DefaultStateGroup(states);
    }

    public static interface Builder {
        public Builder notify(Value.Notify var1);

        public Builder validator(Value.Validator<Boolean> var1);

        public Builder link(Value<Boolean> var1);

        public Builder link(ValueObserver<Boolean> var1);

        public Builder listener(Runnable var1);

        public Builder consumer(Consumer<Boolean> var1);

        public Builder weakListener(Runnable var1);

        public Builder weakConsumer(Consumer<Boolean> var1);

        public State build();
    }

    public static interface Group {
        public void add(State var1);

        public void add(Collection<State> var1);
    }

    public static interface Combination
    extends StateObserver {
        public Conjunction conjunction();

        public void add(StateObserver var1);

        public void remove(StateObserver var1);
    }
}

