/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.state;

import is.codion.common.state.State;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

final class DefaultStateGroup
implements State.Group {
    private final List<State> members = new ArrayList<State>();
    private State previousState;
    private boolean disablingStates = false;

    DefaultStateGroup(State ... states) {
        this(Arrays.asList(states));
    }

    DefaultStateGroup(Collection<State> states) {
        for (State state : Objects.requireNonNull(states)) {
            this.add(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(State state) {
        Objects.requireNonNull(state);
        List<State> list = this.members;
        synchronized (list) {
            if (!this.members.contains(state)) {
                this.members.add(state);
                if (((Boolean)state.get()).booleanValue()) {
                    this.stateChanged(state);
                }
            }
        }
        state.addListener(() -> {
            List<State> list = this.members;
            synchronized (list) {
                this.stateChanged(state);
            }
        });
    }

    @Override
    public void add(Collection<State> states) {
        Objects.requireNonNull(states).forEach(this::add);
    }

    private void stateChanged(State state) {
        if (((Boolean)state.get()).booleanValue()) {
            this.disableOthers(state);
        } else if (!this.disablingStates) {
            this.enablePrevious(state);
        }
    }

    private void disableOthers(State current) {
        this.previousState = this.previousState(current);
        this.disablingStates = true;
        this.members.stream().filter(state -> state != current).filter(Supplier::get).forEach(state -> state.set(false));
        this.disablingStates = false;
    }

    private void enablePrevious(State current) {
        if (this.previousState != null) {
            this.previousState.set(true);
        } else if (this.members.size() > 1) {
            int index = this.members.indexOf(current);
            this.members.get(index == this.members.size() - 1 ? 0 : index + 1).set(true);
        }
        this.previousState = current;
    }

    private State previousState(State current) {
        return this.members.stream().filter(state -> state != current).filter(Supplier::get).findFirst().orElse(null);
    }
}

